/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public class JavaNetRequestExecutor
implements RequestExecutor {
    private static final String DEFAULT_USER_AGENT = "Nuxeo OneDrive Java SDK v1.0";
    private final String accessToken;
    private int timeout;
    private String userAgent = "Nuxeo OneDrive Java SDK v1.0";

    public JavaNetRequestExecutor(String accessToken) {
        this.accessToken = accessToken;
    }

    public JavaNetRequestExecutor withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public JavaNetRequestExecutor withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public RequestExecutor.Upload doPost(URL url, Set<RequestHeader> headers) throws IOException {
        final HttpURLConnection connection = this.createConnection(url, "POST", headers);
        connection.setDoOutput(true);
        connection.connect();
        return new RequestExecutor.Upload(){

            @Override
            public OutputStream getOutputStream() throws IOException {
                return connection.getOutputStream();
            }

            @Override
            public RequestExecutor.Response getResponse() throws IOException {
                return JavaNetRequestExecutor.this.toResponse(connection);
            }
        };
    }

    @Override
    public RequestExecutor.Upload doPut(URL url, Set<RequestHeader> headers) throws IOException {
        final HttpURLConnection connection = this.createConnection(url, "PUT", headers);
        connection.setDoOutput(true);
        connection.connect();
        return new RequestExecutor.Upload(){

            @Override
            public OutputStream getOutputStream() throws IOException {
                return connection.getOutputStream();
            }

            @Override
            public RequestExecutor.Response getResponse() throws IOException {
                return JavaNetRequestExecutor.this.toResponse(connection);
            }
        };
    }

    @Override
    public RequestExecutor.Response doGet(URL url, Set<RequestHeader> headers) throws IOException {
        HttpURLConnection connection = this.createConnection(url, "GET", headers);
        connection.connect();
        return this.toResponse(connection);
    }

    @Override
    public RequestExecutor.Response doDelete(URL url, Set<RequestHeader> headers) throws IOException {
        HttpURLConnection connection = this.createConnection(url, "DELETE", headers);
        connection.connect();
        return this.toResponse(connection);
    }

    @Override
    public RequestExecutor.Upload doPatch(URL url, Set<RequestHeader> headers) throws IOException {
        final HttpURLConnection connection = this.createConnection(url, "PATCH", headers);
        connection.setDoOutput(true);
        connection.connect();
        return new RequestExecutor.Upload(){

            @Override
            public OutputStream getOutputStream() throws IOException {
                return connection.getOutputStream();
            }

            @Override
            public RequestExecutor.Response getResponse() throws IOException {
                return JavaNetRequestExecutor.this.toResponse(connection);
            }
        };
    }

    @Override
    public void addAuthorizationHeader(Set<RequestHeader> headers) {
        headers.add(new RequestHeader("Authorization", String.format("Bearer %s", this.accessToken)));
    }

    protected RequestExecutor.Response toResponse(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        InputStream stream = responseCode >= 400 || responseCode == -1 ? connection.getErrorStream() : connection.getInputStream();
        return new JavaNetResponse(connection, stream);
    }

    protected HttpURLConnection createConnection(URL url, String method, Set<RequestHeader> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        if (this.timeout > 0) {
            connection.setConnectTimeout(this.timeout);
            connection.setReadTimeout(this.timeout);
        }
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("User-Agent", this.userAgent);
        headers.forEach(header -> connection.addRequestProperty(header.getKey(), header.getValue()));
        return connection;
    }

    @Override
    public void close() throws IOException {
    }

    private static final class JavaNetResponse
    extends RequestExecutor.Response {
        private final HttpURLConnection connection;

        public JavaNetResponse(HttpURLConnection connection, InputStream stream) throws IOException {
            super("gzip".equalsIgnoreCase(connection.getContentEncoding()) ? new GZIPInputStream(stream) : stream);
            this.connection = connection;
        }

        @Override
        public int getStatusCode() throws IOException {
            return this.connection.getResponseCode();
        }

        @Override
        public String getStatusMessage() throws IOException {
            return this.connection.getResponseMessage();
        }

        @Override
        public String getLocation() {
            return this.connection.getHeaderField("Location");
        }

        @Override
        public String getHeader(String header) {
            return this.connection.getHeaderField(header);
        }
    }
}

