/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.ParseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.ProxyInputStream;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.RequestExecutor;

public abstract class AbstractResponse<C>
implements Closeable {
    private final RequestExecutor.Response response;
    private final int responseCode;
    private final String responseMessage;
    private final String location;
    private final InputStream inputStream;
    private boolean closed;

    public AbstractResponse(RequestExecutor.Response response) throws IOException {
        this.response = response;
        this.responseCode = response.getStatusCode();
        this.responseMessage = response.getStatusMessage();
        this.location = response.getLocation();
        this.inputStream = response.getInputStream();
        this.validate();
    }

    public RequestExecutor.Response getResponse() {
        return this.response;
    }

    public abstract C getContent() throws IOException;

    public JsonObject getError() throws IOException {
        JsonObject jsonObject;
        InputStreamReader in = new InputStreamReader(this.getBody(), StandardCharsets.UTF_8);
        try {
            jsonObject = Json.parse((Reader)in).asObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException e) {
                return null;
            }
        }
        in.close();
        return jsonObject;
    }

    protected InputStream getBody() throws OneDriveAPIException {
        return new ResponseInputStream();
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getLocation() {
        return this.location;
    }

    public String getHeader(String header) {
        return this.response.getHeader(header);
    }

    protected String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.inputStream.close();
        this.closed = true;
    }

    protected void validate() throws IOException {
        if (!this.isSuccess()) {
            JsonObject error = this.getError();
            if (null == error) {
                throw new OneDriveAPIException(this.responseMessage, this.responseCode);
            }
            String retry = this.getHeader("Retry-After");
            if (retry != null) {
                throw new OneDriveAPIException(this.responseMessage, this.responseCode, error, Integer.valueOf(retry));
            }
            throw new OneDriveAPIException(this.responseMessage, this.responseCode, error);
        }
    }

    public boolean isSuccess() {
        return this.responseCode >= 200 && this.responseCode < 300;
    }

    private class ResponseInputStream
    extends ProxyInputStream {
        public ResponseInputStream() {
            super(AbstractResponse.this.inputStream);
        }

        public void close() throws IOException {
            AbstractResponse.this.close();
        }
    }
}

