/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptEncryptingOutputStream;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TripleCryptWriteFeature
implements Write<Node> {
    private static final Logger log = LogManager.getLogger(TripleCryptWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Write<Node> proxy;

    public TripleCryptWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Write<Node> proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public StatusOutputStream<Node> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Read file key for file %s", file));
            }
            if (null == status.getFilekey()) {
                status.setFilekey(this.nodeid.getFileKey());
            }
            FileKey fileKey = (FileKey)reader.readValue(status.getFilekey().array());
            return new TripleCryptEncryptingOutputStream(this.session, this.nodeid, (StatusOutputStream<Node>)this.proxy.write(file, status, callback), Crypto.createFileEncryptionCipher((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey)), status);
        }
        catch (CryptoSystemException | UnknownVersionException e) {
            throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.proxy.append(file, status);
    }

    public boolean random() {
        return this.proxy.random();
    }
}

