/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.CryptoUtils;
import com.dracoon.sdk.crypto.FileEncryptionCipher;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.model.EncryptedDataContainer;
import com.dracoon.sdk.crypto.model.PlainDataContainer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TripleCryptEncryptingInputStream
extends ProxyInputStream {
    private static final Logger log = LogManager.getLogger(TripleCryptEncryptingInputStream.class);
    private final SDSSession session;
    private final InputStream proxy;
    private final FileEncryptionCipher cipher;
    private final TransferStatus status;
    private ByteBuffer buffer = ByteBuffer.allocate(0);
    private boolean eof = false;

    public TripleCryptEncryptingInputStream(SDSSession session, InputStream proxy, FileEncryptionCipher cipher, TransferStatus status) {
        super(proxy);
        this.session = session;
        this.proxy = proxy;
        this.cipher = cipher;
        this.status = status;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = 0;
            if (this.buffer.hasRemaining()) {
                read = Math.min(len, this.buffer.remaining());
                System.arraycopy(this.buffer.array(), this.buffer.position(), b, off, read);
                this.buffer.position(this.buffer.position() + read);
            } else if (this.eof) {
                return -1;
            }
            if (this.buffer.hasRemaining()) {
                return read;
            }
            if (!this.eof) {
                this.fillBuffer(len);
            }
            return read;
        }
        catch (CryptoException e) {
            throw new IOException(e);
        }
    }

    private void fillBuffer(int len) throws IOException, CryptoException {
        int allocate = len / 8192 * 8192 + 8192;
        this.buffer = ByteBuffer.allocate(allocate);
        byte[] plain = new byte[allocate];
        int read = IOUtils.read((InputStream)this.proxy, (byte[])plain, (int)0, (int)allocate);
        if (read > 0) {
            int position = 0;
            for (int chunkOffset = 0; chunkOffset < read; chunkOffset += 16) {
                int chunkLen = Math.min(16, read - chunkOffset);
                byte[] bytes = Arrays.copyOfRange(plain, chunkOffset, chunkOffset + chunkLen);
                PlainDataContainer data = TripleCryptKeyPair.createPlainDataContainer(bytes, bytes.length);
                EncryptedDataContainer encrypted = this.cipher.processBytes(data);
                byte[] encBuf = encrypted.getContent();
                System.arraycopy(encBuf, 0, this.buffer.array(), position, encBuf.length);
                position += encBuf.length;
            }
            this.buffer.limit(position);
        }
        if (read < allocate) {
            this.eof = true;
            EncryptedDataContainer encContainer = this.cipher.doFinal();
            byte[] content = encContainer.getContent();
            this.buffer = this.combine(this.buffer, ByteBuffer.wrap(content));
            String tag = CryptoUtils.byteArrayToString((byte[])encContainer.getTag());
            ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
            FileKey fileKey = (FileKey)reader.readValue(this.status.getFilekey().array());
            if (null == fileKey.getTag()) {
                fileKey.setTag(tag);
                ObjectWriter writer = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).writerFor(FileKey.class);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                writer.writeValue((OutputStream)out, (Object)fileKey);
                this.status.setFilekey(ByteBuffer.wrap(out.toByteArray()));
            } else {
                log.warn(String.format("Skip setting tag in file key already found in %s", this.status));
            }
        }
    }

    private ByteBuffer combine(ByteBuffer b1, ByteBuffer b2) {
        int pos = b1.position();
        ByteBuffer allocate = ByteBuffer.allocate(b1.limit() + b2.limit()).put(b1).put(b2);
        allocate.position(pos);
        return allocate;
    }
}

