/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAttributes;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="User information")
public class UserItem {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = false;
    @JsonProperty(value="hasManageableRooms")
    private Boolean hasManageableRooms = null;
    @JsonProperty(value="avatarUuid")
    private String avatarUuid = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="lastLoginSuccessAt")
    private DateTime lastLoginSuccessAt = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="isEncryptionEnabled")
    private Boolean isEncryptionEnabled = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="homeRoomId")
    private Long homeRoomId = null;
    @JsonProperty(value="userRoles")
    private RoleList userRoles = null;
    @JsonProperty(value="userAttributes")
    private UserAttributes userAttributes = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="gender")
    private String gender = "n";

    public UserItem id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserItem userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.13.0  Username")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public UserItem firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(required=true, description="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserItem lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(required=true, description="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserItem isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @Schema(required=true, description="User is locked:  * `false` - unlocked  * `true` - locked    User is locked and can not login anymore.")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UserItem hasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.27.0  User has manageable rooms")
    public Boolean isHasManageableRooms() {
        return this.hasManageableRooms;
    }

    public void setHasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
    }

    public UserItem avatarUuid(String avatarUuid) {
        this.avatarUuid = avatarUuid;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.11.0  Avatar UUID")
    public String getAvatarUuid() {
        return this.avatarUuid;
    }

    public void setAvatarUuid(String avatarUuid) {
        this.avatarUuid = avatarUuid;
    }

    public UserItem createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UserItem lastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
        return this;
    }

    @Schema(description="Last successful logon date")
    public DateTime getLastLoginSuccessAt() {
        return this.lastLoginSuccessAt;
    }

    public void setLastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
    }

    public UserItem expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @Schema(description="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public UserItem isEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
        return this;
    }

    @Schema(description="User has generated private key.  Possible if client-side encryption is active for this customer")
    public Boolean isIsEncryptionEnabled() {
        return this.isEncryptionEnabled;
    }

    public void setIsEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
    }

    public UserItem email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="Email ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserItem phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Schema(description="Phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public UserItem homeRoomId(Long homeRoomId) {
        this.homeRoomId = homeRoomId;
        return this;
    }

    @Schema(description="Homeroom ID")
    public Long getHomeRoomId() {
        return this.homeRoomId;
    }

    public void setHomeRoomId(Long homeRoomId) {
        this.homeRoomId = homeRoomId;
    }

    public UserItem userRoles(RoleList userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @Schema(description="")
    public RoleList getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(RoleList userRoles) {
        this.userRoles = userRoles;
    }

    public UserItem userAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    @Schema(description="")
    public UserAttributes getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
    }

    public UserItem lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.7.0  User lock status:  * `0` - locked  * `1` - Web access allowed  * `2` - Web and mobile access allowed    Please use `isLocked` instead.")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UserItem login(String login) {
        this.login = login;
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.13.0  User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserItem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.18.0  Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserItem gender(String gender) {
        this.gender = gender;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.12.0  Gender")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserItem userItem = (UserItem)o;
        return Objects.equals(this.id, userItem.id) && Objects.equals(this.userName, userItem.userName) && Objects.equals(this.firstName, userItem.firstName) && Objects.equals(this.lastName, userItem.lastName) && Objects.equals(this.isLocked, userItem.isLocked) && Objects.equals(this.hasManageableRooms, userItem.hasManageableRooms) && Objects.equals(this.avatarUuid, userItem.avatarUuid) && Objects.equals(this.createdAt, userItem.createdAt) && Objects.equals(this.lastLoginSuccessAt, userItem.lastLoginSuccessAt) && Objects.equals(this.expireAt, userItem.expireAt) && Objects.equals(this.isEncryptionEnabled, userItem.isEncryptionEnabled) && Objects.equals(this.email, userItem.email) && Objects.equals(this.phone, userItem.phone) && Objects.equals(this.homeRoomId, userItem.homeRoomId) && Objects.equals(this.userRoles, userItem.userRoles) && Objects.equals(this.userAttributes, userItem.userAttributes) && Objects.equals(this.lockStatus, userItem.lockStatus) && Objects.equals(this.login, userItem.login) && Objects.equals(this.title, userItem.title) && Objects.equals(this.gender, userItem.gender);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userName, this.firstName, this.lastName, this.isLocked, this.hasManageableRooms, this.avatarUuid, this.createdAt, this.lastLoginSuccessAt, this.expireAt, this.isEncryptionEnabled, this.email, this.phone, this.homeRoomId, this.userRoles, this.userAttributes, this.lockStatus, this.login, this.title, this.gender);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    hasManageableRooms: ").append(this.toIndentedString(this.hasManageableRooms)).append("\n");
        sb.append("    avatarUuid: ").append(this.toIndentedString(this.avatarUuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastLoginSuccessAt: ").append(this.toIndentedString(this.lastLoginSuccessAt)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    isEncryptionEnabled: ").append(this.toIndentedString(this.isEncryptionEnabled)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    homeRoomId: ").append(this.toIndentedString(this.homeRoomId)).append("\n");
        sb.append("    userRoles: ").append(this.toIndentedString(this.userRoles)).append("\n");
        sb.append("    userAttributes: ").append(this.toIndentedString(this.userAttributes)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

