/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Request model for updating room's metadata")
public class UpdateRoomRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="quota")
    private Long quota = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;

    public UpdateRoomRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateRoomRequest quota(Long quota) {
        this.quota = quota;
        return this;
    }

    @Schema(description="Quota in byte")
    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public UpdateRoomRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes  Use empty string to remove.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public UpdateRoomRequest timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the node was created on external file system")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public UpdateRoomRequest timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateRoomRequest updateRoomRequest = (UpdateRoomRequest)o;
        return Objects.equals(this.name, updateRoomRequest.name) && Objects.equals(this.quota, updateRoomRequest.quota) && Objects.equals(this.notes, updateRoomRequest.notes) && Objects.equals(this.timestampCreation, updateRoomRequest.timestampCreation) && Objects.equals(this.timestampModification, updateRoomRequest.timestampModification);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.quota, this.notes, this.timestampCreation, this.timestampModification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateRoomRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

