/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for updating an OpenID Connect IDP configuration")
public class UpdateOpenIdIdpConfigRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="issuer")
    private String issuer = null;
    @JsonProperty(value="authorizationEndPointUrl")
    private String authorizationEndPointUrl = null;
    @JsonProperty(value="tokenEndPointUrl")
    private String tokenEndPointUrl = null;
    @JsonProperty(value="userInfoEndPointUrl")
    private String userInfoEndPointUrl = null;
    @JsonProperty(value="jwksEndPointUrl")
    private String jwksEndPointUrl = null;
    @JsonProperty(value="clientId")
    private String clientId = null;
    @JsonProperty(value="clientSecret")
    private String clientSecret = null;
    @JsonProperty(value="flow")
    private FlowEnum flow = null;
    @JsonProperty(value="scopes")
    private List<String> scopes = null;
    @JsonProperty(value="redirectUris")
    private List<String> redirectUris = null;
    @JsonProperty(value="pkceEnabled")
    private Boolean pkceEnabled = false;
    @JsonProperty(value="pkceChallengeMethod")
    private String pkceChallengeMethod = null;
    @JsonProperty(value="mappingClaim")
    private String mappingClaim = null;
    @JsonProperty(value="fallbackMappingClaim")
    private String fallbackMappingClaim = null;
    @JsonProperty(value="resetFallbackMappingClaim")
    private Boolean resetFallbackMappingClaim = null;
    @JsonProperty(value="userInfoSource")
    private UserInfoSourceEnum userInfoSource = null;
    @JsonProperty(value="userImportEnabled")
    private Boolean userImportEnabled = false;
    @JsonProperty(value="userImportGroup")
    private Long userImportGroup = null;
    @JsonProperty(value="userUpdateEnabled")
    private Boolean userUpdateEnabled = false;
    @JsonProperty(value="userManagementUrl")
    private String userManagementUrl = null;

    public UpdateOpenIdIdpConfigRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the IDP")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateOpenIdIdpConfigRequest issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Schema(description="Issuer identifier of the IDP  The value is a case sensitive URL.")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public UpdateOpenIdIdpConfigRequest authorizationEndPointUrl(String authorizationEndPointUrl) {
        this.authorizationEndPointUrl = authorizationEndPointUrl;
        return this;
    }

    @Schema(description="URL of the authorization endpoint")
    public String getAuthorizationEndPointUrl() {
        return this.authorizationEndPointUrl;
    }

    public void setAuthorizationEndPointUrl(String authorizationEndPointUrl) {
        this.authorizationEndPointUrl = authorizationEndPointUrl;
    }

    public UpdateOpenIdIdpConfigRequest tokenEndPointUrl(String tokenEndPointUrl) {
        this.tokenEndPointUrl = tokenEndPointUrl;
        return this;
    }

    @Schema(description="URL of the token endpoint")
    public String getTokenEndPointUrl() {
        return this.tokenEndPointUrl;
    }

    public void setTokenEndPointUrl(String tokenEndPointUrl) {
        this.tokenEndPointUrl = tokenEndPointUrl;
    }

    public UpdateOpenIdIdpConfigRequest userInfoEndPointUrl(String userInfoEndPointUrl) {
        this.userInfoEndPointUrl = userInfoEndPointUrl;
        return this;
    }

    @Schema(description="URL of the user info endpoint")
    public String getUserInfoEndPointUrl() {
        return this.userInfoEndPointUrl;
    }

    public void setUserInfoEndPointUrl(String userInfoEndPointUrl) {
        this.userInfoEndPointUrl = userInfoEndPointUrl;
    }

    public UpdateOpenIdIdpConfigRequest jwksEndPointUrl(String jwksEndPointUrl) {
        this.jwksEndPointUrl = jwksEndPointUrl;
        return this;
    }

    @Schema(description="URL of the JWKS endpoint")
    public String getJwksEndPointUrl() {
        return this.jwksEndPointUrl;
    }

    public void setJwksEndPointUrl(String jwksEndPointUrl) {
        this.jwksEndPointUrl = jwksEndPointUrl;
    }

    public UpdateOpenIdIdpConfigRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(description="ID of the OpenID client")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public UpdateOpenIdIdpConfigRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Schema(description="Secret, which client uses at authentication.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public UpdateOpenIdIdpConfigRequest flow(FlowEnum flow) {
        this.flow = flow;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Flow, which is used at authentication")
    public FlowEnum getFlow() {
        return this.flow;
    }

    public void setFlow(FlowEnum flow) {
        this.flow = flow;
    }

    public UpdateOpenIdIdpConfigRequest scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public UpdateOpenIdIdpConfigRequest addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Schema(description="List of requested scopes  Usually `openid` and the names of the requested claims.")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public UpdateOpenIdIdpConfigRequest redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public UpdateOpenIdIdpConfigRequest addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Schema(description="URIs, to which a user is redirected after authorization.")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public UpdateOpenIdIdpConfigRequest pkceEnabled(Boolean pkceEnabled) {
        this.pkceEnabled = pkceEnabled;
        return this;
    }

    @Schema(description="Determines whether PKCE is enabled.  cf. [RFC 7636](https://tools.ietf.org/html/rfc7636)")
    public Boolean isPkceEnabled() {
        return this.pkceEnabled;
    }

    public void setPkceEnabled(Boolean pkceEnabled) {
        this.pkceEnabled = pkceEnabled;
    }

    public UpdateOpenIdIdpConfigRequest pkceChallengeMethod(String pkceChallengeMethod) {
        this.pkceChallengeMethod = pkceChallengeMethod;
        return this;
    }

    @Schema(description="PKCE code challenge method.  cf. [RFC 7636](https://tools.ietf.org/html/rfc7636)")
    public String getPkceChallengeMethod() {
        return this.pkceChallengeMethod;
    }

    public void setPkceChallengeMethod(String pkceChallengeMethod) {
        this.pkceChallengeMethod = pkceChallengeMethod;
    }

    public UpdateOpenIdIdpConfigRequest mappingClaim(String mappingClaim) {
        this.mappingClaim = mappingClaim;
        return this;
    }

    @Schema(description="Name of the claim which is used for the user mapping.")
    public String getMappingClaim() {
        return this.mappingClaim;
    }

    public void setMappingClaim(String mappingClaim) {
        this.mappingClaim = mappingClaim;
    }

    public UpdateOpenIdIdpConfigRequest fallbackMappingClaim(String fallbackMappingClaim) {
        this.fallbackMappingClaim = fallbackMappingClaim;
        return this;
    }

    @Schema(description="Name of the claim which is used for the user mapping fallback.")
    public String getFallbackMappingClaim() {
        return this.fallbackMappingClaim;
    }

    public void setFallbackMappingClaim(String fallbackMappingClaim) {
        this.fallbackMappingClaim = fallbackMappingClaim;
    }

    public UpdateOpenIdIdpConfigRequest resetFallbackMappingClaim(Boolean resetFallbackMappingClaim) {
        this.resetFallbackMappingClaim = resetFallbackMappingClaim;
        return this;
    }

    @Schema(description="Set `true` to reset `fallbackMappingClaim`.")
    public Boolean isResetFallbackMappingClaim() {
        return this.resetFallbackMappingClaim;
    }

    public void setResetFallbackMappingClaim(Boolean resetFallbackMappingClaim) {
        this.resetFallbackMappingClaim = resetFallbackMappingClaim;
    }

    public UpdateOpenIdIdpConfigRequest userInfoSource(UserInfoSourceEnum userInfoSource) {
        this.userInfoSource = userInfoSource;
        return this;
    }

    @Schema(description="&#128640; Since v4.23.0  Source, which is used to get user information at the import or update of a user.")
    public UserInfoSourceEnum getUserInfoSource() {
        return this.userInfoSource;
    }

    public void setUserInfoSource(UserInfoSourceEnum userInfoSource) {
        this.userInfoSource = userInfoSource;
    }

    public UpdateOpenIdIdpConfigRequest userImportEnabled(Boolean userImportEnabled) {
        this.userImportEnabled = userImportEnabled;
        return this;
    }

    @Schema(description="Determines if a DRACOON account is automatically created for a new user  who successfully logs on with his / her AD / IDP account.")
    public Boolean isUserImportEnabled() {
        return this.userImportEnabled;
    }

    public void setUserImportEnabled(Boolean userImportEnabled) {
        this.userImportEnabled = userImportEnabled;
    }

    public UpdateOpenIdIdpConfigRequest userImportGroup(Long userImportGroup) {
        this.userImportGroup = userImportGroup;
        return this;
    }

    @Schema(description="User group that is assigned to users who are created by automatic import.  Reset with `0`")
    public Long getUserImportGroup() {
        return this.userImportGroup;
    }

    public void setUserImportGroup(Long userImportGroup) {
        this.userImportGroup = userImportGroup;
    }

    public UpdateOpenIdIdpConfigRequest userUpdateEnabled(Boolean userUpdateEnabled) {
        this.userUpdateEnabled = userUpdateEnabled;
        return this;
    }

    @Schema(description="Determines if the DRACOON account is updated with data from AD / IDP.  For OpenID Connect, the scopes `email` and `profile` are needed.")
    public Boolean isUserUpdateEnabled() {
        return this.userUpdateEnabled;
    }

    public void setUserUpdateEnabled(Boolean userUpdateEnabled) {
        this.userUpdateEnabled = userUpdateEnabled;
    }

    public UpdateOpenIdIdpConfigRequest userManagementUrl(String userManagementUrl) {
        this.userManagementUrl = userManagementUrl;
        return this;
    }

    @Schema(description="URL of the user management UI.  Use empty string to remove.")
    public String getUserManagementUrl() {
        return this.userManagementUrl;
    }

    public void setUserManagementUrl(String userManagementUrl) {
        this.userManagementUrl = userManagementUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOpenIdIdpConfigRequest updateOpenIdIdpConfigRequest = (UpdateOpenIdIdpConfigRequest)o;
        return Objects.equals(this.name, updateOpenIdIdpConfigRequest.name) && Objects.equals(this.issuer, updateOpenIdIdpConfigRequest.issuer) && Objects.equals(this.authorizationEndPointUrl, updateOpenIdIdpConfigRequest.authorizationEndPointUrl) && Objects.equals(this.tokenEndPointUrl, updateOpenIdIdpConfigRequest.tokenEndPointUrl) && Objects.equals(this.userInfoEndPointUrl, updateOpenIdIdpConfigRequest.userInfoEndPointUrl) && Objects.equals(this.jwksEndPointUrl, updateOpenIdIdpConfigRequest.jwksEndPointUrl) && Objects.equals(this.clientId, updateOpenIdIdpConfigRequest.clientId) && Objects.equals(this.clientSecret, updateOpenIdIdpConfigRequest.clientSecret) && Objects.equals((Object)this.flow, (Object)updateOpenIdIdpConfigRequest.flow) && Objects.equals(this.scopes, updateOpenIdIdpConfigRequest.scopes) && Objects.equals(this.redirectUris, updateOpenIdIdpConfigRequest.redirectUris) && Objects.equals(this.pkceEnabled, updateOpenIdIdpConfigRequest.pkceEnabled) && Objects.equals(this.pkceChallengeMethod, updateOpenIdIdpConfigRequest.pkceChallengeMethod) && Objects.equals(this.mappingClaim, updateOpenIdIdpConfigRequest.mappingClaim) && Objects.equals(this.fallbackMappingClaim, updateOpenIdIdpConfigRequest.fallbackMappingClaim) && Objects.equals(this.resetFallbackMappingClaim, updateOpenIdIdpConfigRequest.resetFallbackMappingClaim) && Objects.equals((Object)this.userInfoSource, (Object)updateOpenIdIdpConfigRequest.userInfoSource) && Objects.equals(this.userImportEnabled, updateOpenIdIdpConfigRequest.userImportEnabled) && Objects.equals(this.userImportGroup, updateOpenIdIdpConfigRequest.userImportGroup) && Objects.equals(this.userUpdateEnabled, updateOpenIdIdpConfigRequest.userUpdateEnabled) && Objects.equals(this.userManagementUrl, updateOpenIdIdpConfigRequest.userManagementUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.issuer, this.authorizationEndPointUrl, this.tokenEndPointUrl, this.userInfoEndPointUrl, this.jwksEndPointUrl, this.clientId, this.clientSecret, this.flow, this.scopes, this.redirectUris, this.pkceEnabled, this.pkceChallengeMethod, this.mappingClaim, this.fallbackMappingClaim, this.resetFallbackMappingClaim, this.userInfoSource, this.userImportEnabled, this.userImportGroup, this.userUpdateEnabled, this.userManagementUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateOpenIdIdpConfigRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    authorizationEndPointUrl: ").append(this.toIndentedString(this.authorizationEndPointUrl)).append("\n");
        sb.append("    tokenEndPointUrl: ").append(this.toIndentedString(this.tokenEndPointUrl)).append("\n");
        sb.append("    userInfoEndPointUrl: ").append(this.toIndentedString(this.userInfoEndPointUrl)).append("\n");
        sb.append("    jwksEndPointUrl: ").append(this.toIndentedString(this.jwksEndPointUrl)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString((Object)this.flow)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    pkceEnabled: ").append(this.toIndentedString(this.pkceEnabled)).append("\n");
        sb.append("    pkceChallengeMethod: ").append(this.toIndentedString(this.pkceChallengeMethod)).append("\n");
        sb.append("    mappingClaim: ").append(this.toIndentedString(this.mappingClaim)).append("\n");
        sb.append("    fallbackMappingClaim: ").append(this.toIndentedString(this.fallbackMappingClaim)).append("\n");
        sb.append("    resetFallbackMappingClaim: ").append(this.toIndentedString(this.resetFallbackMappingClaim)).append("\n");
        sb.append("    userInfoSource: ").append(this.toIndentedString((Object)this.userInfoSource)).append("\n");
        sb.append("    userImportEnabled: ").append(this.toIndentedString(this.userImportEnabled)).append("\n");
        sb.append("    userImportGroup: ").append(this.toIndentedString(this.userImportGroup)).append("\n");
        sb.append("    userUpdateEnabled: ").append(this.toIndentedString(this.userUpdateEnabled)).append("\n");
        sb.append("    userManagementUrl: ").append(this.toIndentedString(this.userManagementUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FlowEnum {
        AUTHORIZATION_CODE("authorization_code"),
        HYBRID("hybrid");

        private String value;

        private FlowEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FlowEnum fromValue(String text) {
            for (FlowEnum b : FlowEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum UserInfoSourceEnum {
        USER_INFO_ENDPOINT("user_info_endpoint"),
        ID_TOKEN("id_token");

        private String value;

        private UserInfoSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserInfoSourceEnum fromValue(String text) {
            for (UserInfoSourceEnum b : UserInfoSourceEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

