/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CharacterRules;
import ch.cyberduck.core.sds.io.swagger.client.model.PasswordExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.UserLockout;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Request model for updating login password policies")
public class UpdateLoginPasswordPolicies {
    @JsonProperty(value="characterRules")
    private CharacterRules characterRules = null;
    @JsonProperty(value="minLength")
    private Integer minLength = null;
    @JsonProperty(value="rejectDictionaryWords")
    private Boolean rejectDictionaryWords = null;
    @JsonProperty(value="rejectUserInfo")
    private Boolean rejectUserInfo = null;
    @JsonProperty(value="rejectKeyboardPatterns")
    private Boolean rejectKeyboardPatterns = null;
    @JsonProperty(value="numberOfArchivedPasswords")
    private Integer numberOfArchivedPasswords = null;
    @JsonProperty(value="passwordExpiration")
    private PasswordExpiration passwordExpiration = null;
    @JsonProperty(value="userLockout")
    private UserLockout userLockout = null;
    @JsonProperty(value="enforceLoginPasswordChange")
    private Boolean enforceLoginPasswordChange = false;

    public UpdateLoginPasswordPolicies characterRules(CharacterRules characterRules) {
        this.characterRules = characterRules;
        return this;
    }

    @Schema(description="")
    public CharacterRules getCharacterRules() {
        return this.characterRules;
    }

    public void setCharacterRules(CharacterRules characterRules) {
        this.characterRules = characterRules;
    }

    public UpdateLoginPasswordPolicies minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Schema(description="Minimum number of characters a password must contain")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public UpdateLoginPasswordPolicies rejectDictionaryWords(Boolean rejectDictionaryWords) {
        this.rejectDictionaryWords = rejectDictionaryWords;
        return this;
    }

    @Schema(description="Determines whether a password must NOT contain word(s) from a dictionary")
    public Boolean isRejectDictionaryWords() {
        return this.rejectDictionaryWords;
    }

    public void setRejectDictionaryWords(Boolean rejectDictionaryWords) {
        this.rejectDictionaryWords = rejectDictionaryWords;
    }

    public UpdateLoginPasswordPolicies rejectUserInfo(Boolean rejectUserInfo) {
        this.rejectUserInfo = rejectUserInfo;
        return this;
    }

    @Schema(description="Determines whether a password must NOT contain user info (first name, last name, email, user name)")
    public Boolean isRejectUserInfo() {
        return this.rejectUserInfo;
    }

    public void setRejectUserInfo(Boolean rejectUserInfo) {
        this.rejectUserInfo = rejectUserInfo;
    }

    public UpdateLoginPasswordPolicies rejectKeyboardPatterns(Boolean rejectKeyboardPatterns) {
        this.rejectKeyboardPatterns = rejectKeyboardPatterns;
        return this;
    }

    @Schema(description="Determines whether a password must NOT contain keyboard patterns (e.g. `qwertz`, `asdf`)  (min. 4 character pattern)")
    public Boolean isRejectKeyboardPatterns() {
        return this.rejectKeyboardPatterns;
    }

    public void setRejectKeyboardPatterns(Boolean rejectKeyboardPatterns) {
        this.rejectKeyboardPatterns = rejectKeyboardPatterns;
    }

    public UpdateLoginPasswordPolicies numberOfArchivedPasswords(Integer numberOfArchivedPasswords) {
        this.numberOfArchivedPasswords = numberOfArchivedPasswords;
        return this;
    }

    @Schema(description="Number of passwords to archive  (must be between `0` and `10`; `0` means that password history is disabled)")
    public Integer getNumberOfArchivedPasswords() {
        return this.numberOfArchivedPasswords;
    }

    public void setNumberOfArchivedPasswords(Integer numberOfArchivedPasswords) {
        this.numberOfArchivedPasswords = numberOfArchivedPasswords;
    }

    public UpdateLoginPasswordPolicies passwordExpiration(PasswordExpiration passwordExpiration) {
        this.passwordExpiration = passwordExpiration;
        return this;
    }

    @Schema(description="")
    public PasswordExpiration getPasswordExpiration() {
        return this.passwordExpiration;
    }

    public void setPasswordExpiration(PasswordExpiration passwordExpiration) {
        this.passwordExpiration = passwordExpiration;
    }

    public UpdateLoginPasswordPolicies userLockout(UserLockout userLockout) {
        this.userLockout = userLockout;
        return this;
    }

    @Schema(description="")
    public UserLockout getUserLockout() {
        return this.userLockout;
    }

    public void setUserLockout(UserLockout userLockout) {
        this.userLockout = userLockout;
    }

    public UpdateLoginPasswordPolicies enforceLoginPasswordChange(Boolean enforceLoginPasswordChange) {
        this.enforceLoginPasswordChange = enforceLoginPasswordChange;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.24.0  Determines whether a login password change should be enforced for all users  Only takes effect, if login password policies get stricter")
    public Boolean isEnforceLoginPasswordChange() {
        return this.enforceLoginPasswordChange;
    }

    public void setEnforceLoginPasswordChange(Boolean enforceLoginPasswordChange) {
        this.enforceLoginPasswordChange = enforceLoginPasswordChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateLoginPasswordPolicies updateLoginPasswordPolicies = (UpdateLoginPasswordPolicies)o;
        return Objects.equals(this.characterRules, updateLoginPasswordPolicies.characterRules) && Objects.equals(this.minLength, updateLoginPasswordPolicies.minLength) && Objects.equals(this.rejectDictionaryWords, updateLoginPasswordPolicies.rejectDictionaryWords) && Objects.equals(this.rejectUserInfo, updateLoginPasswordPolicies.rejectUserInfo) && Objects.equals(this.rejectKeyboardPatterns, updateLoginPasswordPolicies.rejectKeyboardPatterns) && Objects.equals(this.numberOfArchivedPasswords, updateLoginPasswordPolicies.numberOfArchivedPasswords) && Objects.equals(this.passwordExpiration, updateLoginPasswordPolicies.passwordExpiration) && Objects.equals(this.userLockout, updateLoginPasswordPolicies.userLockout) && Objects.equals(this.enforceLoginPasswordChange, updateLoginPasswordPolicies.enforceLoginPasswordChange);
    }

    public int hashCode() {
        return Objects.hash(this.characterRules, this.minLength, this.rejectDictionaryWords, this.rejectUserInfo, this.rejectKeyboardPatterns, this.numberOfArchivedPasswords, this.passwordExpiration, this.userLockout, this.enforceLoginPasswordChange);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateLoginPasswordPolicies {\n");
        sb.append("    characterRules: ").append(this.toIndentedString(this.characterRules)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    rejectDictionaryWords: ").append(this.toIndentedString(this.rejectDictionaryWords)).append("\n");
        sb.append("    rejectUserInfo: ").append(this.toIndentedString(this.rejectUserInfo)).append("\n");
        sb.append("    rejectKeyboardPatterns: ").append(this.toIndentedString(this.rejectKeyboardPatterns)).append("\n");
        sb.append("    numberOfArchivedPasswords: ").append(this.toIndentedString(this.numberOfArchivedPasswords)).append("\n");
        sb.append("    passwordExpiration: ").append(this.toIndentedString(this.passwordExpiration)).append("\n");
        sb.append("    userLockout: ").append(this.toIndentedString(this.userLockout)).append("\n");
        sb.append("    enforceLoginPasswordChange: ").append(this.toIndentedString(this.enforceLoginPasswordChange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

