/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Subscribed node information")
public class SubscribedNode {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="authParentId")
    private Long authParentId = null;

    public SubscribedNode id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Node ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SubscribedNode type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(description="Node type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SubscribedNode authParentId(Long authParentId) {
        this.authParentId = authParentId;
        return this;
    }

    @Schema(description="Auth parent room ID")
    public Long getAuthParentId() {
        return this.authParentId;
    }

    public void setAuthParentId(Long authParentId) {
        this.authParentId = authParentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedNode subscribedNode = (SubscribedNode)o;
        return Objects.equals(this.id, subscribedNode.id) && Objects.equals((Object)this.type, (Object)subscribedNode.type) && Objects.equals(this.authParentId, subscribedNode.authParentId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.authParentId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscribedNode {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    authParentId: ").append(this.toIndentedString(this.authParentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ROOM("room"),
        FOLDER("folder"),
        FILE("file");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

