/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="OAuth client information")
public class OAuthClient {
    @JsonProperty(value="clientId")
    private String clientId = null;
    @JsonProperty(value="clientSecret")
    private String clientSecret = null;
    @JsonProperty(value="clientName")
    private String clientName = null;
    @JsonProperty(value="clientType")
    private ClientTypeEnum clientType = null;
    @JsonProperty(value="isStandard")
    private Boolean isStandard = null;
    @JsonProperty(value="isExternal")
    private Boolean isExternal = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="grantTypes")
    private List<GrantTypesEnum> grantTypes = new ArrayList<GrantTypesEnum>();
    @JsonProperty(value="redirectUris")
    private List<String> redirectUris = null;
    @JsonProperty(value="accessTokenValidity")
    private Integer accessTokenValidity = null;
    @JsonProperty(value="refreshTokenValidity")
    private Integer refreshTokenValidity = null;
    @JsonProperty(value="approvalValidity")
    private Integer approvalValidity = null;

    public OAuthClient clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(required=true, description="ID of the OAuth client")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthClient clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Schema(description="Secret, which client uses at authentication.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthClient clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @Schema(description="Name, which is shown at the client configuration and authorization.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public OAuthClient clientType(ClientTypeEnum clientType) {
        this.clientType = clientType;
        return this;
    }

    @Schema(description="Determines whether client is a confidential or public client.")
    public ClientTypeEnum getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientTypeEnum clientType) {
        this.clientType = clientType;
    }

    public OAuthClient isStandard(Boolean isStandard) {
        this.isStandard = isStandard;
        return this;
    }

    @Schema(description="Determines whether client is a standard client.")
    public Boolean isIsStandard() {
        return this.isStandard;
    }

    public void setIsStandard(Boolean isStandard) {
        this.isStandard = isStandard;
    }

    public OAuthClient isExternal(Boolean isExternal) {
        this.isExternal = isExternal;
        return this;
    }

    @Schema(description="Determines whether client is an external client.")
    public Boolean isIsExternal() {
        return this.isExternal;
    }

    public void setIsExternal(Boolean isExternal) {
        this.isExternal = isExternal;
    }

    public OAuthClient isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(description="Determines whether client is enabled.")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public OAuthClient grantTypes(List<GrantTypesEnum> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public OAuthClient addGrantTypesItem(GrantTypesEnum grantTypesItem) {
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    @Schema(required=true, description="Authorized grant types  * `authorization_code`  * `implicit`  * `password`  * `client_credentials`  * `refresh_token`    cf. [RFC 6749](https://tools.ietf.org/html/rfc6749)")
    public List<GrantTypesEnum> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantTypesEnum> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public OAuthClient redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public OAuthClient addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Schema(description="URIs, to which a user is redirected after authorization.")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public OAuthClient accessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
        return this;
    }

    @Schema(description="Validity of the access token in seconds.")
    public Integer getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public OAuthClient refreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
        return this;
    }

    @Schema(description="Validity of the refresh token in seconds.")
    public Integer getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public OAuthClient approvalValidity(Integer approvalValidity) {
        this.approvalValidity = approvalValidity;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Validity of the approval interval in seconds.")
    public Integer getApprovalValidity() {
        return this.approvalValidity;
    }

    public void setApprovalValidity(Integer approvalValidity) {
        this.approvalValidity = approvalValidity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthClient oauthClient = (OAuthClient)o;
        return Objects.equals(this.clientId, oauthClient.clientId) && Objects.equals(this.clientSecret, oauthClient.clientSecret) && Objects.equals(this.clientName, oauthClient.clientName) && Objects.equals((Object)this.clientType, (Object)oauthClient.clientType) && Objects.equals(this.isStandard, oauthClient.isStandard) && Objects.equals(this.isExternal, oauthClient.isExternal) && Objects.equals(this.isEnabled, oauthClient.isEnabled) && Objects.equals(this.grantTypes, oauthClient.grantTypes) && Objects.equals(this.redirectUris, oauthClient.redirectUris) && Objects.equals(this.accessTokenValidity, oauthClient.accessTokenValidity) && Objects.equals(this.refreshTokenValidity, oauthClient.refreshTokenValidity) && Objects.equals(this.approvalValidity, oauthClient.approvalValidity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.clientSecret, this.clientName, this.clientType, this.isStandard, this.isExternal, this.isEnabled, this.grantTypes, this.redirectUris, this.accessTokenValidity, this.refreshTokenValidity, this.approvalValidity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthClient {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    clientType: ").append(this.toIndentedString((Object)this.clientType)).append("\n");
        sb.append("    isStandard: ").append(this.toIndentedString(this.isStandard)).append("\n");
        sb.append("    isExternal: ").append(this.toIndentedString(this.isExternal)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    grantTypes: ").append(this.toIndentedString(this.grantTypes)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    accessTokenValidity: ").append(this.toIndentedString(this.accessTokenValidity)).append("\n");
        sb.append("    refreshTokenValidity: ").append(this.toIndentedString(this.refreshTokenValidity)).append("\n");
        sb.append("    approvalValidity: ").append(this.toIndentedString(this.approvalValidity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ClientTypeEnum {
        CONFIDENTIAL("confidential"),
        PUBLIC("public");

        private String value;

        private ClientTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClientTypeEnum fromValue(String text) {
            for (ClientTypeEnum b : ClientTypeEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum GrantTypesEnum {
        AUTHORIZATION_CODE("authorization_code"),
        CLIENT_CREDENTIALS("client_credentials"),
        IMPLICIT("implicit"),
        PASSWORD("password"),
        REFRESH_TOKEN("refresh_token");

        private String value;

        private GrantTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GrantTypesEnum fromValue(String text) {
            for (GrantTypesEnum b : GrantTypesEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

