/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.EncryptionInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.NodePermissions;
import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Node information (Node can be a room, folder or file)")
public class Node {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="parentPath")
    private String parentPath = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="createdBy")
    private UserInfo createdBy = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="updatedBy")
    private UserInfo updatedBy = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="hash")
    private String hash = null;
    @JsonProperty(value="fileType")
    private String fileType = null;
    @JsonProperty(value="mediaType")
    private String mediaType = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="classification")
    private ClassificationEnum classification = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="permissions")
    private NodePermissions permissions = null;
    @JsonProperty(value="inheritPermissions")
    private Boolean inheritPermissions = null;
    @JsonProperty(value="isEncrypted")
    private Boolean isEncrypted = null;
    @JsonProperty(value="encryptionInfo")
    private EncryptionInfo encryptionInfo = null;
    @JsonProperty(value="cntDeletedVersions")
    private Integer cntDeletedVersions = null;
    @JsonProperty(value="cntComments")
    private Integer cntComments = null;
    @JsonProperty(value="cntDownloadShares")
    private Integer cntDownloadShares = null;
    @JsonProperty(value="cntUploadShares")
    private Integer cntUploadShares = null;
    @JsonProperty(value="recycleBinRetentionPeriod")
    private Integer recycleBinRetentionPeriod = null;
    @JsonProperty(value="hasActivitiesLog")
    private Boolean hasActivitiesLog = true;
    @JsonProperty(value="quota")
    private Long quota = null;
    @JsonProperty(value="isFavorite")
    private Boolean isFavorite = null;
    @JsonProperty(value="branchVersion")
    private Long branchVersion = null;
    @JsonProperty(value="mediaToken")
    private String mediaToken = null;
    @JsonProperty(value="isBrowsable")
    private Boolean isBrowsable = null;
    @JsonProperty(value="cntRooms")
    private Integer cntRooms = null;
    @JsonProperty(value="cntFolders")
    private Integer cntFolders = null;
    @JsonProperty(value="cntFiles")
    private Integer cntFiles = null;
    @JsonProperty(value="authParentId")
    private Long authParentId = null;
    @JsonProperty(value="cntChildren")
    private Integer cntChildren = null;
    @JsonProperty(value="hasRecycleBin")
    private Boolean hasRecycleBin = null;
    @JsonProperty(value="children")
    private List<Node> children = null;

    public Node id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Node ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Node type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Node type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Node name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the node was created on external file system")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public Node timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public Node parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Parent node ID (room or folder)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Node parentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    @Schema(description="Parent node path  `/` if node is a root node (room)")
    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public Node createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Node createdBy(UserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public Node updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(description="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Node updatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(description="")
    public UserInfo getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Node expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @Schema(description="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public Node hash(String hash) {
        this.hash = hash;
        return this;
    }

    @Schema(description="MD5 hash of file")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Node fileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    @Schema(description="File type / extension (for files only)")
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public Node mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Schema(description="File media type (for files only)")
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Node size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(description="Node size in byte")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Node classification(ClassificationEnum classification) {
        this.classification = classification;
        return this;
    }

    @Schema(description="Classification ID:  * `1` - public  * `2` - internal  * `3` - confidential  * `4` - strictly confidential")
    public ClassificationEnum getClassification() {
        return this.classification;
    }

    public void setClassification(ClassificationEnum classification) {
        this.classification = classification;
    }

    public Node notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Node permissions(NodePermissions permissions) {
        this.permissions = permissions;
        return this;
    }

    @Schema(description="")
    public NodePermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(NodePermissions permissions) {
        this.permissions = permissions;
    }

    public Node inheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
        return this;
    }

    @Schema(description="Inherit permissions from parent room  (default: `false` if `parentId` is `0`; otherwise: `true`)")
    public Boolean isInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public Node isEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    @Schema(description="Encryption state")
    public Boolean isIsEncrypted() {
        return this.isEncrypted;
    }

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public Node encryptionInfo(EncryptionInfo encryptionInfo) {
        this.encryptionInfo = encryptionInfo;
        return this;
    }

    @Schema(description="")
    public EncryptionInfo getEncryptionInfo() {
        return this.encryptionInfo;
    }

    public void setEncryptionInfo(EncryptionInfo encryptionInfo) {
        this.encryptionInfo = encryptionInfo;
    }

    public Node cntDeletedVersions(Integer cntDeletedVersions) {
        this.cntDeletedVersions = cntDeletedVersions;
        return this;
    }

    @Schema(description="Number of deleted versions of this file / folder  (for rooms / folders only)")
    public Integer getCntDeletedVersions() {
        return this.cntDeletedVersions;
    }

    public void setCntDeletedVersions(Integer cntDeletedVersions) {
        this.cntDeletedVersions = cntDeletedVersions;
    }

    public Node cntComments(Integer cntComments) {
        this.cntComments = cntComments;
        return this;
    }

    @Schema(description="Returns the number of comments of this node.")
    public Integer getCntComments() {
        return this.cntComments;
    }

    public void setCntComments(Integer cntComments) {
        this.cntComments = cntComments;
    }

    public Node cntDownloadShares(Integer cntDownloadShares) {
        this.cntDownloadShares = cntDownloadShares;
        return this;
    }

    @Schema(description="Returns the number of Download Shares of this node.")
    public Integer getCntDownloadShares() {
        return this.cntDownloadShares;
    }

    public void setCntDownloadShares(Integer cntDownloadShares) {
        this.cntDownloadShares = cntDownloadShares;
    }

    public Node cntUploadShares(Integer cntUploadShares) {
        this.cntUploadShares = cntUploadShares;
        return this;
    }

    @Schema(description="Returns the number of Upload Shares of this node.")
    public Integer getCntUploadShares() {
        return this.cntUploadShares;
    }

    public void setCntUploadShares(Integer cntUploadShares) {
        this.cntUploadShares = cntUploadShares;
    }

    public Node recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
        return this;
    }

    @Schema(description="Retention period for deleted nodes in days")
    public Integer getRecycleBinRetentionPeriod() {
        return this.recycleBinRetentionPeriod;
    }

    public void setRecycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
    }

    public Node hasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
        return this;
    }

    @Schema(description="Is activities log active (for rooms only)")
    public Boolean isHasActivitiesLog() {
        return this.hasActivitiesLog;
    }

    public void setHasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
    }

    public Node quota(Long quota) {
        this.quota = quota;
        return this;
    }

    @Schema(description="Quota in byte")
    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public Node isFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    @Schema(description="Node is marked as favorite (for rooms / folders only)")
    public Boolean isIsFavorite() {
        return this.isFavorite;
    }

    public void setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public Node branchVersion(Long branchVersion) {
        this.branchVersion = branchVersion;
        return this;
    }

    @Schema(description="Version of last change in this node or a node further down the tree.")
    public Long getBranchVersion() {
        return this.branchVersion;
    }

    public void setBranchVersion(Long branchVersion) {
        this.branchVersion = branchVersion;
    }

    public Node mediaToken(String mediaToken) {
        this.mediaToken = mediaToken;
        return this;
    }

    @Schema(description="Media server media token")
    public String getMediaToken() {
        return this.mediaToken;
    }

    public void setMediaToken(String mediaToken) {
        this.mediaToken = mediaToken;
    }

    public Node isBrowsable(Boolean isBrowsable) {
        this.isBrowsable = isBrowsable;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Determines whether node is browsable by client (for rooms only)")
    public Boolean isIsBrowsable() {
        return this.isBrowsable;
    }

    public void setIsBrowsable(Boolean isBrowsable) {
        this.isBrowsable = isBrowsable;
    }

    public Node cntRooms(Integer cntRooms) {
        this.cntRooms = cntRooms;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Amount of direct child rooms where this node is the parent node  (no recursion; for rooms only)")
    public Integer getCntRooms() {
        return this.cntRooms;
    }

    public void setCntRooms(Integer cntRooms) {
        this.cntRooms = cntRooms;
    }

    public Node cntFolders(Integer cntFolders) {
        this.cntFolders = cntFolders;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Amount of direct child folders where this node is the parent node  (no recursion; for rooms / folders only)")
    public Integer getCntFolders() {
        return this.cntFolders;
    }

    public void setCntFolders(Integer cntFolders) {
        this.cntFolders = cntFolders;
    }

    public Node cntFiles(Integer cntFiles) {
        this.cntFiles = cntFiles;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Amount of direct child files where this node is the parent node  (no recursion; for rooms / folders only)")
    public Integer getCntFiles() {
        return this.cntFiles;
    }

    public void setCntFiles(Integer cntFiles) {
        this.cntFiles = cntFiles;
    }

    public Node authParentId(Long authParentId) {
        this.authParentId = authParentId;
        return this;
    }

    @Schema(description="&#128640; Since v4.15.0  Auth parent room ID")
    public Long getAuthParentId() {
        return this.authParentId;
    }

    public void setAuthParentId(Long authParentId) {
        this.authParentId = authParentId;
    }

    public Node cntChildren(Integer cntChildren) {
        this.cntChildren = cntChildren;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Number of direct children  (no recursion; for rooms / folders only)")
    public Integer getCntChildren() {
        return this.cntChildren;
    }

    public void setCntChildren(Integer cntChildren) {
        this.cntChildren = cntChildren;
    }

    public Node hasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.10.0  Is recycle bin active (for rooms only)  Recycle bin is always on (disabling is not possible).")
    public Boolean isHasRecycleBin() {
        return this.hasRecycleBin;
    }

    public void setHasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
    }

    public Node children(List<Node> children) {
        this.children = children;
        return this;
    }

    public Node addChildrenItem(Node childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.10.0  Child nodes list (if requested)  (for rooms / folders only)")
    public List<Node> getChildren() {
        return this.children;
    }

    public void setChildren(List<Node> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.id, node.id) && Objects.equals((Object)this.type, (Object)node.type) && Objects.equals(this.name, node.name) && Objects.equals(this.timestampCreation, node.timestampCreation) && Objects.equals(this.timestampModification, node.timestampModification) && Objects.equals(this.parentId, node.parentId) && Objects.equals(this.parentPath, node.parentPath) && Objects.equals(this.createdAt, node.createdAt) && Objects.equals(this.createdBy, node.createdBy) && Objects.equals(this.updatedAt, node.updatedAt) && Objects.equals(this.updatedBy, node.updatedBy) && Objects.equals(this.expireAt, node.expireAt) && Objects.equals(this.hash, node.hash) && Objects.equals(this.fileType, node.fileType) && Objects.equals(this.mediaType, node.mediaType) && Objects.equals(this.size, node.size) && Objects.equals((Object)this.classification, (Object)node.classification) && Objects.equals(this.notes, node.notes) && Objects.equals(this.permissions, node.permissions) && Objects.equals(this.inheritPermissions, node.inheritPermissions) && Objects.equals(this.isEncrypted, node.isEncrypted) && Objects.equals(this.encryptionInfo, node.encryptionInfo) && Objects.equals(this.cntDeletedVersions, node.cntDeletedVersions) && Objects.equals(this.cntComments, node.cntComments) && Objects.equals(this.cntDownloadShares, node.cntDownloadShares) && Objects.equals(this.cntUploadShares, node.cntUploadShares) && Objects.equals(this.recycleBinRetentionPeriod, node.recycleBinRetentionPeriod) && Objects.equals(this.hasActivitiesLog, node.hasActivitiesLog) && Objects.equals(this.quota, node.quota) && Objects.equals(this.isFavorite, node.isFavorite) && Objects.equals(this.branchVersion, node.branchVersion) && Objects.equals(this.mediaToken, node.mediaToken) && Objects.equals(this.isBrowsable, node.isBrowsable) && Objects.equals(this.cntRooms, node.cntRooms) && Objects.equals(this.cntFolders, node.cntFolders) && Objects.equals(this.cntFiles, node.cntFiles) && Objects.equals(this.authParentId, node.authParentId) && Objects.equals(this.cntChildren, node.cntChildren) && Objects.equals(this.hasRecycleBin, node.hasRecycleBin) && Objects.equals(this.children, node.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.name, this.timestampCreation, this.timestampModification, this.parentId, this.parentPath, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.expireAt, this.hash, this.fileType, this.mediaType, this.size, this.classification, this.notes, this.permissions, this.inheritPermissions, this.isEncrypted, this.encryptionInfo, this.cntDeletedVersions, this.cntComments, this.cntDownloadShares, this.cntUploadShares, this.recycleBinRetentionPeriod, this.hasActivitiesLog, this.quota, this.isFavorite, this.branchVersion, this.mediaToken, this.isBrowsable, this.cntRooms, this.cntFolders, this.cntFiles, this.authParentId, this.cntChildren, this.hasRecycleBin, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Node {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    parentPath: ").append(this.toIndentedString(this.parentPath)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString(this.fileType)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString((Object)this.classification)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    inheritPermissions: ").append(this.toIndentedString(this.inheritPermissions)).append("\n");
        sb.append("    isEncrypted: ").append(this.toIndentedString(this.isEncrypted)).append("\n");
        sb.append("    encryptionInfo: ").append(this.toIndentedString(this.encryptionInfo)).append("\n");
        sb.append("    cntDeletedVersions: ").append(this.toIndentedString(this.cntDeletedVersions)).append("\n");
        sb.append("    cntComments: ").append(this.toIndentedString(this.cntComments)).append("\n");
        sb.append("    cntDownloadShares: ").append(this.toIndentedString(this.cntDownloadShares)).append("\n");
        sb.append("    cntUploadShares: ").append(this.toIndentedString(this.cntUploadShares)).append("\n");
        sb.append("    recycleBinRetentionPeriod: ").append(this.toIndentedString(this.recycleBinRetentionPeriod)).append("\n");
        sb.append("    hasActivitiesLog: ").append(this.toIndentedString(this.hasActivitiesLog)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    isFavorite: ").append(this.toIndentedString(this.isFavorite)).append("\n");
        sb.append("    branchVersion: ").append(this.toIndentedString(this.branchVersion)).append("\n");
        sb.append("    mediaToken: ").append(this.toIndentedString(this.mediaToken)).append("\n");
        sb.append("    isBrowsable: ").append(this.toIndentedString(this.isBrowsable)).append("\n");
        sb.append("    cntRooms: ").append(this.toIndentedString(this.cntRooms)).append("\n");
        sb.append("    cntFolders: ").append(this.toIndentedString(this.cntFolders)).append("\n");
        sb.append("    cntFiles: ").append(this.toIndentedString(this.cntFiles)).append("\n");
        sb.append("    authParentId: ").append(this.toIndentedString(this.authParentId)).append("\n");
        sb.append("    cntChildren: ").append(this.toIndentedString(this.cntChildren)).append("\n");
        sb.append("    hasRecycleBin: ").append(this.toIndentedString(this.hasRecycleBin)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ROOM("room"),
        FOLDER("folder"),
        FILE("file");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ClassificationEnum {
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_3(3),
        NUMBER_4(4);

        private Integer value;

        private ClassificationEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClassificationEnum fromValue(Integer text) {
            for (ClassificationEnum b : ClassificationEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

