/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.FirstAdminUser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Customer information")
public class NewCustomerResponse {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="companyName")
    private String companyName = null;
    @JsonProperty(value="customerContractType")
    private CustomerContractTypeEnum customerContractType = null;
    @JsonProperty(value="quotaMax")
    private Long quotaMax = null;
    @JsonProperty(value="userMax")
    private Integer userMax = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = false;
    @JsonProperty(value="trialDays")
    private Integer trialDays = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="firstAdminUser")
    private FirstAdminUser firstAdminUser = null;
    @JsonProperty(value="customerAttributes")
    private CustomerAttributes customerAttributes = null;
    @JsonProperty(value="providerCustomerId")
    private String providerCustomerId = null;
    @JsonProperty(value="webhooksMax")
    private Long webhooksMax = null;
    @JsonProperty(value="customerUuid")
    private String customerUuid = null;
    @JsonProperty(value="activationCode")
    private String activationCode = null;
    @JsonProperty(value="lockStatus")
    private Boolean lockStatus = false;

    public NewCustomerResponse id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(description="Unique identifier for the customer")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public NewCustomerResponse companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Schema(required=true, description="Company name")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public NewCustomerResponse customerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
        return this;
    }

    @Schema(required=true, description="Customer type")
    public CustomerContractTypeEnum getCustomerContractType() {
        return this.customerContractType;
    }

    public void setCustomerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
    }

    public NewCustomerResponse quotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
        return this;
    }

    @Schema(required=true, description="Maximal disc space which can be allocated by customer in bytes. -1 for unlimited")
    public Long getQuotaMax() {
        return this.quotaMax;
    }

    public void setQuotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
    }

    public NewCustomerResponse userMax(Integer userMax) {
        this.userMax = userMax;
        return this;
    }

    @Schema(required=true, description="Maximal number of users")
    public Integer getUserMax() {
        return this.userMax;
    }

    public void setUserMax(Integer userMax) {
        this.userMax = userMax;
    }

    public NewCustomerResponse isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @Schema(description="Customer is locked:  * `false` - unlocked  * `true` - locked    All users of this customer will be blocked and can not login anymore.")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public NewCustomerResponse trialDays(Integer trialDays) {
        this.trialDays = trialDays;
        return this;
    }

    @Schema(description="Number of days left for trial period (relevant only for type `demo`)  (not used)")
    public Integer getTrialDays() {
        return this.trialDays;
    }

    public void setTrialDays(Integer trialDays) {
        this.trialDays = trialDays;
    }

    public NewCustomerResponse createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Schema(description="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public NewCustomerResponse firstAdminUser(FirstAdminUser firstAdminUser) {
        this.firstAdminUser = firstAdminUser;
        return this;
    }

    @Schema(required=true, description="")
    public FirstAdminUser getFirstAdminUser() {
        return this.firstAdminUser;
    }

    public void setFirstAdminUser(FirstAdminUser firstAdminUser) {
        this.firstAdminUser = firstAdminUser;
    }

    public NewCustomerResponse customerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
        return this;
    }

    @Schema(description="")
    public CustomerAttributes getCustomerAttributes() {
        return this.customerAttributes;
    }

    public void setCustomerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
    }

    public NewCustomerResponse providerCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
        return this;
    }

    @Schema(description="Provider customer ID")
    public String getProviderCustomerId() {
        return this.providerCustomerId;
    }

    public void setProviderCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
    }

    public NewCustomerResponse webhooksMax(Long webhooksMax) {
        this.webhooksMax = webhooksMax;
        return this;
    }

    @Schema(description="&#128640; Since v4.19.0  Maximal number of webhooks")
    public Long getWebhooksMax() {
        return this.webhooksMax;
    }

    public void setWebhooksMax(Long webhooksMax) {
        this.webhooksMax = webhooksMax;
    }

    public NewCustomerResponse customerUuid(String customerUuid) {
        this.customerUuid = customerUuid;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.21.0  Customer UUID")
    public String getCustomerUuid() {
        return this.customerUuid;
    }

    public void setCustomerUuid(String customerUuid) {
        this.customerUuid = customerUuid;
    }

    public NewCustomerResponse activationCode(String activationCode) {
        this.activationCode = activationCode;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.8.0  Customer activation code string:  * valid only for types `free` and `demo`  * for `pay` customers it is empty")
    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public NewCustomerResponse lockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @Schema(required=true, description="&#128679; Deprecated since v4.7.0  Customer lock status:  * `false` - unlocked  * `true` - locked    Please use `isLocked` instead.  All users of this customer will be blocked and can not login anymore.")
    public Boolean isLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewCustomerResponse newCustomerResponse = (NewCustomerResponse)o;
        return Objects.equals(this.id, newCustomerResponse.id) && Objects.equals(this.companyName, newCustomerResponse.companyName) && Objects.equals((Object)this.customerContractType, (Object)newCustomerResponse.customerContractType) && Objects.equals(this.quotaMax, newCustomerResponse.quotaMax) && Objects.equals(this.userMax, newCustomerResponse.userMax) && Objects.equals(this.isLocked, newCustomerResponse.isLocked) && Objects.equals(this.trialDays, newCustomerResponse.trialDays) && Objects.equals(this.createdAt, newCustomerResponse.createdAt) && Objects.equals(this.firstAdminUser, newCustomerResponse.firstAdminUser) && Objects.equals(this.customerAttributes, newCustomerResponse.customerAttributes) && Objects.equals(this.providerCustomerId, newCustomerResponse.providerCustomerId) && Objects.equals(this.webhooksMax, newCustomerResponse.webhooksMax) && Objects.equals(this.customerUuid, newCustomerResponse.customerUuid) && Objects.equals(this.activationCode, newCustomerResponse.activationCode) && Objects.equals(this.lockStatus, newCustomerResponse.lockStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.companyName, this.customerContractType, this.quotaMax, this.userMax, this.isLocked, this.trialDays, this.createdAt, this.firstAdminUser, this.customerAttributes, this.providerCustomerId, this.webhooksMax, this.customerUuid, this.activationCode, this.lockStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewCustomerResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    customerContractType: ").append(this.toIndentedString((Object)this.customerContractType)).append("\n");
        sb.append("    quotaMax: ").append(this.toIndentedString(this.quotaMax)).append("\n");
        sb.append("    userMax: ").append(this.toIndentedString(this.userMax)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    trialDays: ").append(this.toIndentedString(this.trialDays)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    firstAdminUser: ").append(this.toIndentedString(this.firstAdminUser)).append("\n");
        sb.append("    customerAttributes: ").append(this.toIndentedString(this.customerAttributes)).append("\n");
        sb.append("    providerCustomerId: ").append(this.toIndentedString(this.providerCustomerId)).append("\n");
        sb.append("    webhooksMax: ").append(this.toIndentedString(this.webhooksMax)).append("\n");
        sb.append("    customerUuid: ").append(this.toIndentedString(this.customerUuid)).append("\n");
        sb.append("    activationCode: ").append(this.toIndentedString(this.activationCode)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomerContractTypeEnum {
        DEMO("demo"),
        FREE("free"),
        PAY("pay");

        private String value;

        private CustomerContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomerContractTypeEnum fromValue(String text) {
            for (CustomerContractTypeEnum b : CustomerContractTypeEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

