/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Moved node information")
public class MoveNode {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;

    public MoveNode id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Source node ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MoveNode name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="New node name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MoveNode timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the node was created on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public MoveNode timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveNode moveNode = (MoveNode)o;
        return Objects.equals(this.id, moveNode.id) && Objects.equals(this.name, moveNode.name) && Objects.equals(this.timestampCreation, moveNode.timestampCreation) && Objects.equals(this.timestampModification, moveNode.timestampModification);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.timestampCreation, this.timestampModification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MoveNode {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

