/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for creating an Upload Share")
public class CreateUploadShareRequest {
    @JsonProperty(value="targetId")
    private Long targetId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="filesExpiryPeriod")
    private Integer filesExpiryPeriod = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="internalNotes")
    private String internalNotes = null;
    @JsonProperty(value="showUploadedFiles")
    private Boolean showUploadedFiles = false;
    @JsonProperty(value="maxSlots")
    private Integer maxSlots = null;
    @JsonProperty(value="maxSize")
    private Long maxSize = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;
    @JsonProperty(value="textMessageRecipients")
    private List<String> textMessageRecipients = null;
    @JsonProperty(value="showCreatorName")
    private Boolean showCreatorName = false;
    @JsonProperty(value="showCreatorUsername")
    private Boolean showCreatorUsername = false;
    @JsonProperty(value="notifyCreator")
    private Boolean notifyCreator = false;
    @JsonProperty(value="creatorLanguage")
    private String creatorLanguage = null;
    @JsonProperty(value="sendMail")
    private Boolean sendMail = false;
    @JsonProperty(value="mailRecipients")
    private String mailRecipients = null;
    @JsonProperty(value="mailSubject")
    private String mailSubject = null;
    @JsonProperty(value="mailBody")
    private String mailBody = null;
    @JsonProperty(value="sendSms")
    private Boolean sendSms = false;
    @JsonProperty(value="smsRecipients")
    private String smsRecipients = null;

    public CreateUploadShareRequest targetId(Long targetId) {
        this.targetId = targetId;
        return this;
    }

    @Schema(required=true, description="Target room or folder ID")
    public Long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public CreateUploadShareRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Alias name  (default: name of the shared node)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateUploadShareRequest password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="Password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateUploadShareRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public CreateUploadShareRequest filesExpiryPeriod(Integer filesExpiryPeriod) {
        this.filesExpiryPeriod = filesExpiryPeriod;
        return this;
    }

    @Schema(description="Number of days after which uploaded files expire")
    public Integer getFilesExpiryPeriod() {
        return this.filesExpiryPeriod;
    }

    public void setFilesExpiryPeriod(Integer filesExpiryPeriod) {
        this.filesExpiryPeriod = filesExpiryPeriod;
    }

    public CreateUploadShareRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateUploadShareRequest internalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Internal notes")
    public String getInternalNotes() {
        return this.internalNotes;
    }

    public void setInternalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
    }

    public CreateUploadShareRequest showUploadedFiles(Boolean showUploadedFiles) {
        this.showUploadedFiles = showUploadedFiles;
        return this;
    }

    @Schema(description="Allow display of already uploaded files")
    public Boolean isShowUploadedFiles() {
        return this.showUploadedFiles;
    }

    public void setShowUploadedFiles(Boolean showUploadedFiles) {
        this.showUploadedFiles = showUploadedFiles;
    }

    public CreateUploadShareRequest maxSlots(Integer maxSlots) {
        this.maxSlots = maxSlots;
        return this;
    }

    @Schema(description="Maximal amount of files to upload")
    public Integer getMaxSlots() {
        return this.maxSlots;
    }

    public void setMaxSlots(Integer maxSlots) {
        this.maxSlots = maxSlots;
    }

    public CreateUploadShareRequest maxSize(Long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @Schema(description="Maximal total size of uploaded files (in bytes)")
    public Long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public CreateUploadShareRequest receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @Schema(description="Language tag for messages to receiver")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public CreateUploadShareRequest textMessageRecipients(List<String> textMessageRecipients) {
        this.textMessageRecipients = textMessageRecipients;
        return this;
    }

    public CreateUploadShareRequest addTextMessageRecipientsItem(String textMessageRecipientsItem) {
        if (this.textMessageRecipients == null) {
            this.textMessageRecipients = new ArrayList<String>();
        }
        this.textMessageRecipients.add(textMessageRecipientsItem);
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  List of recipient FQTNs  E.123 / E.164 Format")
    public List<String> getTextMessageRecipients() {
        return this.textMessageRecipients;
    }

    public void setTextMessageRecipients(List<String> textMessageRecipients) {
        this.textMessageRecipients = textMessageRecipients;
    }

    public CreateUploadShareRequest showCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Show creator first and last name.")
    public Boolean isShowCreatorName() {
        return this.showCreatorName;
    }

    public void setShowCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
    }

    public CreateUploadShareRequest showCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Show creator email address.")
    public Boolean isShowCreatorUsername() {
        return this.showCreatorUsername;
    }

    public void setShowCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
    }

    public CreateUploadShareRequest notifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.20.0  Notify creator on every upload.")
    public Boolean isNotifyCreator() {
        return this.notifyCreator;
    }

    public void setNotifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
    }

    public CreateUploadShareRequest creatorLanguage(String creatorLanguage) {
        this.creatorLanguage = creatorLanguage;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.20.0  Language tag for messages to creator")
    public String getCreatorLanguage() {
        return this.creatorLanguage;
    }

    public void setCreatorLanguage(String creatorLanguage) {
        this.creatorLanguage = creatorLanguage;
    }

    public CreateUploadShareRequest sendMail(Boolean sendMail) {
        this.sendMail = sendMail;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Notify recipients via email  Please use `POST /shares/uploads/{share_id}/email` API instead.")
    public Boolean isSendMail() {
        return this.sendMail;
    }

    public void setSendMail(Boolean sendMail) {
        this.sendMail = sendMail;
    }

    public CreateUploadShareRequest mailRecipients(String mailRecipients) {
        this.mailRecipients = mailRecipients;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  CSV string of recipient email addresses")
    public String getMailRecipients() {
        return this.mailRecipients;
    }

    public void setMailRecipients(String mailRecipients) {
        this.mailRecipients = mailRecipients;
    }

    public CreateUploadShareRequest mailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Notification email subject")
    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public CreateUploadShareRequest mailBody(String mailBody) {
        this.mailBody = mailBody;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Notification email content")
    public String getMailBody() {
        return this.mailBody;
    }

    public void setMailBody(String mailBody) {
        this.mailBody = mailBody;
    }

    public CreateUploadShareRequest sendSms(Boolean sendSms) {
        this.sendSms = sendSms;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Send share password via SMS  Please use `textMessageRecipients` attribute instead.")
    public Boolean isSendSms() {
        return this.sendSms;
    }

    public void setSendSms(Boolean sendSms) {
        this.sendSms = sendSms;
    }

    public CreateUploadShareRequest smsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  CSV string of recipient MSISDNs")
    public String getSmsRecipients() {
        return this.smsRecipients;
    }

    public void setSmsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUploadShareRequest createUploadShareRequest = (CreateUploadShareRequest)o;
        return Objects.equals(this.targetId, createUploadShareRequest.targetId) && Objects.equals(this.name, createUploadShareRequest.name) && Objects.equals(this.password, createUploadShareRequest.password) && Objects.equals(this.expiration, createUploadShareRequest.expiration) && Objects.equals(this.filesExpiryPeriod, createUploadShareRequest.filesExpiryPeriod) && Objects.equals(this.notes, createUploadShareRequest.notes) && Objects.equals(this.internalNotes, createUploadShareRequest.internalNotes) && Objects.equals(this.showUploadedFiles, createUploadShareRequest.showUploadedFiles) && Objects.equals(this.maxSlots, createUploadShareRequest.maxSlots) && Objects.equals(this.maxSize, createUploadShareRequest.maxSize) && Objects.equals(this.receiverLanguage, createUploadShareRequest.receiverLanguage) && Objects.equals(this.textMessageRecipients, createUploadShareRequest.textMessageRecipients) && Objects.equals(this.showCreatorName, createUploadShareRequest.showCreatorName) && Objects.equals(this.showCreatorUsername, createUploadShareRequest.showCreatorUsername) && Objects.equals(this.notifyCreator, createUploadShareRequest.notifyCreator) && Objects.equals(this.creatorLanguage, createUploadShareRequest.creatorLanguage) && Objects.equals(this.sendMail, createUploadShareRequest.sendMail) && Objects.equals(this.mailRecipients, createUploadShareRequest.mailRecipients) && Objects.equals(this.mailSubject, createUploadShareRequest.mailSubject) && Objects.equals(this.mailBody, createUploadShareRequest.mailBody) && Objects.equals(this.sendSms, createUploadShareRequest.sendSms) && Objects.equals(this.smsRecipients, createUploadShareRequest.smsRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.targetId, this.name, this.password, this.expiration, this.filesExpiryPeriod, this.notes, this.internalNotes, this.showUploadedFiles, this.maxSlots, this.maxSize, this.receiverLanguage, this.textMessageRecipients, this.showCreatorName, this.showCreatorUsername, this.notifyCreator, this.creatorLanguage, this.sendMail, this.mailRecipients, this.mailSubject, this.mailBody, this.sendSms, this.smsRecipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUploadShareRequest {\n");
        sb.append("    targetId: ").append(this.toIndentedString(this.targetId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    filesExpiryPeriod: ").append(this.toIndentedString(this.filesExpiryPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    internalNotes: ").append(this.toIndentedString(this.internalNotes)).append("\n");
        sb.append("    showUploadedFiles: ").append(this.toIndentedString(this.showUploadedFiles)).append("\n");
        sb.append("    maxSlots: ").append(this.toIndentedString(this.maxSlots)).append("\n");
        sb.append("    maxSize: ").append(this.toIndentedString(this.maxSize)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("    textMessageRecipients: ").append(this.toIndentedString(this.textMessageRecipients)).append("\n");
        sb.append("    showCreatorName: ").append(this.toIndentedString(this.showCreatorName)).append("\n");
        sb.append("    showCreatorUsername: ").append(this.toIndentedString(this.showCreatorUsername)).append("\n");
        sb.append("    notifyCreator: ").append(this.toIndentedString(this.notifyCreator)).append("\n");
        sb.append("    creatorLanguage: ").append(this.toIndentedString(this.creatorLanguage)).append("\n");
        sb.append("    sendMail: ").append(this.toIndentedString(this.sendMail)).append("\n");
        sb.append("    mailRecipients: ").append(this.toIndentedString(this.mailRecipients)).append("\n");
        sb.append("    mailSubject: ").append(this.toIndentedString(this.mailSubject)).append("\n");
        sb.append("    mailBody: ").append(this.toIndentedString(this.mailBody)).append("\n");
        sb.append("    sendSms: ").append(this.toIndentedString(this.sendSms)).append("\n");
        sb.append("    smsRecipients: ").append(this.toIndentedString(this.smsRecipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

