/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Request model for creating a room")
public class CreateRoomRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="recycleBinRetentionPeriod")
    private Integer recycleBinRetentionPeriod = null;
    @JsonProperty(value="quota")
    private Long quota = null;
    @JsonProperty(value="inheritPermissions")
    private Boolean inheritPermissions = null;
    @JsonProperty(value="adminIds")
    private List<Long> adminIds = null;
    @JsonProperty(value="adminGroupIds")
    private List<Long> adminGroupIds = null;
    @JsonProperty(value="newGroupMemberAcceptance")
    private NewGroupMemberAcceptanceEnum newGroupMemberAcceptance = NewGroupMemberAcceptanceEnum.AUTOALLOW;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="hasActivitiesLog")
    private Boolean hasActivitiesLog = true;
    @JsonProperty(value="classification")
    private ClassificationEnum classification = ClassificationEnum.NUMBER_2;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;
    @JsonProperty(value="hasRecycleBin")
    private Boolean hasRecycleBin = null;

    public CreateRoomRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateRoomRequest parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Parent room ID or `null` (not 0) to create a top level room")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public CreateRoomRequest recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
        return this;
    }

    @Schema(description="Retention period for deleted nodes in days")
    public Integer getRecycleBinRetentionPeriod() {
        return this.recycleBinRetentionPeriod;
    }

    public void setRecycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
    }

    public CreateRoomRequest quota(Long quota) {
        this.quota = quota;
        return this;
    }

    @Schema(description="Quota in byte")
    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public CreateRoomRequest inheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
        return this;
    }

    @Schema(description="Inherit permissions from parent room  (default: `false` if `parentId` is `0`; otherwise: `true`)")
    public Boolean isInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public CreateRoomRequest adminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
        return this;
    }

    public CreateRoomRequest addAdminIdsItem(Long adminIdsItem) {
        if (this.adminIds == null) {
            this.adminIds = new ArrayList<Long>();
        }
        this.adminIds.add(adminIdsItem);
        return this;
    }

    @Schema(description="List of user ids  A room requires at least one admin (user or group)")
    public List<Long> getAdminIds() {
        return this.adminIds;
    }

    public void setAdminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
    }

    public CreateRoomRequest adminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
        return this;
    }

    public CreateRoomRequest addAdminGroupIdsItem(Long adminGroupIdsItem) {
        if (this.adminGroupIds == null) {
            this.adminGroupIds = new ArrayList<Long>();
        }
        this.adminGroupIds.add(adminGroupIdsItem);
        return this;
    }

    @Schema(description="List of group ids  A room requires at least one admin (user or group)")
    public List<Long> getAdminGroupIds() {
        return this.adminGroupIds;
    }

    public void setAdminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
    }

    public CreateRoomRequest newGroupMemberAcceptance(NewGroupMemberAcceptanceEnum newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
        return this;
    }

    @Schema(description="Behaviour when new users are added to the group:  * `autoallow`  * `pending`    Only relevant if `adminGroupIds` has items.")
    public NewGroupMemberAcceptanceEnum getNewGroupMemberAcceptance() {
        return this.newGroupMemberAcceptance;
    }

    public void setNewGroupMemberAcceptance(NewGroupMemberAcceptanceEnum newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
    }

    public CreateRoomRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes  Use empty string to remove.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateRoomRequest hasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
        return this;
    }

    @Schema(description="Is activities log active (for rooms only)")
    public Boolean isHasActivitiesLog() {
        return this.hasActivitiesLog;
    }

    public void setHasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
    }

    public CreateRoomRequest classification(ClassificationEnum classification) {
        this.classification = classification;
        return this;
    }

    @Schema(description="Classification ID:  * `1` - public  * `2` - internal  * `3` - confidential  * `4` - strictly confidential    Provided (or default) classification is taken from room  when file gets uploaded without any classification.")
    public ClassificationEnum getClassification() {
        return this.classification;
    }

    public void setClassification(ClassificationEnum classification) {
        this.classification = classification;
    }

    public CreateRoomRequest timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the node was created on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public CreateRoomRequest timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system  (default: current server datetime in UTC format)")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public CreateRoomRequest hasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.10.0  Is recycle bin active (for rooms only)  Recycle bin is always on (disabling is not possible).")
    public Boolean isHasRecycleBin() {
        return this.hasRecycleBin;
    }

    public void setHasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRoomRequest createRoomRequest = (CreateRoomRequest)o;
        return Objects.equals(this.name, createRoomRequest.name) && Objects.equals(this.parentId, createRoomRequest.parentId) && Objects.equals(this.recycleBinRetentionPeriod, createRoomRequest.recycleBinRetentionPeriod) && Objects.equals(this.quota, createRoomRequest.quota) && Objects.equals(this.inheritPermissions, createRoomRequest.inheritPermissions) && Objects.equals(this.adminIds, createRoomRequest.adminIds) && Objects.equals(this.adminGroupIds, createRoomRequest.adminGroupIds) && Objects.equals((Object)this.newGroupMemberAcceptance, (Object)createRoomRequest.newGroupMemberAcceptance) && Objects.equals(this.notes, createRoomRequest.notes) && Objects.equals(this.hasActivitiesLog, createRoomRequest.hasActivitiesLog) && Objects.equals((Object)this.classification, (Object)createRoomRequest.classification) && Objects.equals(this.timestampCreation, createRoomRequest.timestampCreation) && Objects.equals(this.timestampModification, createRoomRequest.timestampModification) && Objects.equals(this.hasRecycleBin, createRoomRequest.hasRecycleBin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.parentId, this.recycleBinRetentionPeriod, this.quota, this.inheritPermissions, this.adminIds, this.adminGroupIds, this.newGroupMemberAcceptance, this.notes, this.hasActivitiesLog, this.classification, this.timestampCreation, this.timestampModification, this.hasRecycleBin});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRoomRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    recycleBinRetentionPeriod: ").append(this.toIndentedString(this.recycleBinRetentionPeriod)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    inheritPermissions: ").append(this.toIndentedString(this.inheritPermissions)).append("\n");
        sb.append("    adminIds: ").append(this.toIndentedString(this.adminIds)).append("\n");
        sb.append("    adminGroupIds: ").append(this.toIndentedString(this.adminGroupIds)).append("\n");
        sb.append("    newGroupMemberAcceptance: ").append(this.toIndentedString((Object)this.newGroupMemberAcceptance)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    hasActivitiesLog: ").append(this.toIndentedString(this.hasActivitiesLog)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString((Object)this.classification)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("    hasRecycleBin: ").append(this.toIndentedString(this.hasRecycleBin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NewGroupMemberAcceptanceEnum {
        AUTOALLOW("autoallow"),
        PENDING("pending");

        private String value;

        private NewGroupMemberAcceptanceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NewGroupMemberAcceptanceEnum fromValue(String text) {
            for (NewGroupMemberAcceptanceEnum b : NewGroupMemberAcceptanceEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ClassificationEnum {
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_3(3),
        NUMBER_4(4);

        private Integer value;

        private ClassificationEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClassificationEnum fromValue(Integer text) {
            for (ClassificationEnum b : ClassificationEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

