/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for creating a Download Share")
public class CreateDownloadShareRequest {
    @JsonProperty(value="nodeId")
    private Long nodeId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="internalNotes")
    private String internalNotes = null;
    @JsonProperty(value="showCreatorName")
    private Boolean showCreatorName = false;
    @JsonProperty(value="showCreatorUsername")
    private Boolean showCreatorUsername = false;
    @JsonProperty(value="maxDownloads")
    private Integer maxDownloads = null;
    @JsonProperty(value="keyPair")
    private UserKeyPairContainer keyPair = null;
    @JsonProperty(value="fileKey")
    private FileKey fileKey = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;
    @JsonProperty(value="textMessageRecipients")
    private List<String> textMessageRecipients = null;
    @JsonProperty(value="notifyCreator")
    private Boolean notifyCreator = false;
    @JsonProperty(value="creatorLanguage")
    private String creatorLanguage = null;
    @JsonProperty(value="sendMail")
    private Boolean sendMail = false;
    @JsonProperty(value="mailRecipients")
    private String mailRecipients = null;
    @JsonProperty(value="mailSubject")
    private String mailSubject = null;
    @JsonProperty(value="mailBody")
    private String mailBody = null;
    @JsonProperty(value="sendSms")
    private Boolean sendSms = false;
    @JsonProperty(value="smsRecipients")
    private String smsRecipients = null;

    public CreateDownloadShareRequest nodeId(Long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Schema(required=true, description="Source node ID")
    public Long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public CreateDownloadShareRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Alias name  (default: name of the shared node)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateDownloadShareRequest password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="Access password, not allowed for encrypted shares")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateDownloadShareRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public CreateDownloadShareRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @Schema(description="User notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateDownloadShareRequest internalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Internal notes")
    public String getInternalNotes() {
        return this.internalNotes;
    }

    public void setInternalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
    }

    public CreateDownloadShareRequest showCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
        return this;
    }

    @Schema(description="Show creator first and last name.")
    public Boolean isShowCreatorName() {
        return this.showCreatorName;
    }

    public void setShowCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
    }

    public CreateDownloadShareRequest showCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
        return this;
    }

    @Schema(description="Show creator email address.")
    public Boolean isShowCreatorUsername() {
        return this.showCreatorUsername;
    }

    public void setShowCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
    }

    public CreateDownloadShareRequest maxDownloads(Integer maxDownloads) {
        this.maxDownloads = maxDownloads;
        return this;
    }

    @Schema(description="Max allowed downloads")
    public Integer getMaxDownloads() {
        return this.maxDownloads;
    }

    public void setMaxDownloads(Integer maxDownloads) {
        this.maxDownloads = maxDownloads;
    }

    public CreateDownloadShareRequest keyPair(UserKeyPairContainer keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    @Schema(description="")
    public UserKeyPairContainer getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(UserKeyPairContainer keyPair) {
        this.keyPair = keyPair;
    }

    public CreateDownloadShareRequest fileKey(FileKey fileKey) {
        this.fileKey = fileKey;
        return this;
    }

    @Schema(description="")
    public FileKey getFileKey() {
        return this.fileKey;
    }

    public void setFileKey(FileKey fileKey) {
        this.fileKey = fileKey;
    }

    public CreateDownloadShareRequest receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @Schema(description="Language tag for messages to receiver")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public CreateDownloadShareRequest textMessageRecipients(List<String> textMessageRecipients) {
        this.textMessageRecipients = textMessageRecipients;
        return this;
    }

    public CreateDownloadShareRequest addTextMessageRecipientsItem(String textMessageRecipientsItem) {
        if (this.textMessageRecipients == null) {
            this.textMessageRecipients = new ArrayList<String>();
        }
        this.textMessageRecipients.add(textMessageRecipientsItem);
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  List of recipient FQTNs  E.123 / E.164 Format")
    public List<String> getTextMessageRecipients() {
        return this.textMessageRecipients;
    }

    public void setTextMessageRecipients(List<String> textMessageRecipients) {
        this.textMessageRecipients = textMessageRecipients;
    }

    public CreateDownloadShareRequest notifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.20.0  Notify creator on every download.")
    public Boolean isNotifyCreator() {
        return this.notifyCreator;
    }

    public void setNotifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
    }

    public CreateDownloadShareRequest creatorLanguage(String creatorLanguage) {
        this.creatorLanguage = creatorLanguage;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.20.0  Language tag for messages to creator")
    public String getCreatorLanguage() {
        return this.creatorLanguage;
    }

    public void setCreatorLanguage(String creatorLanguage) {
        this.creatorLanguage = creatorLanguage;
    }

    public CreateDownloadShareRequest sendMail(Boolean sendMail) {
        this.sendMail = sendMail;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Notify recipients via email  Please use `POST /shares/downloads/{share_id}/email` API instead.")
    public Boolean isSendMail() {
        return this.sendMail;
    }

    public void setSendMail(Boolean sendMail) {
        this.sendMail = sendMail;
    }

    public CreateDownloadShareRequest mailRecipients(String mailRecipients) {
        this.mailRecipients = mailRecipients;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  CSV string of recipient email addresses")
    public String getMailRecipients() {
        return this.mailRecipients;
    }

    public void setMailRecipients(String mailRecipients) {
        this.mailRecipients = mailRecipients;
    }

    public CreateDownloadShareRequest mailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Notification email subject")
    public String getMailSubject() {
        return this.mailSubject;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public CreateDownloadShareRequest mailBody(String mailBody) {
        this.mailBody = mailBody;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Notification email content")
    public String getMailBody() {
        return this.mailBody;
    }

    public void setMailBody(String mailBody) {
        this.mailBody = mailBody;
    }

    public CreateDownloadShareRequest sendSms(Boolean sendSms) {
        this.sendSms = sendSms;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Send share password via SMS  Please use `textMessageRecipients` attribute instead.")
    public Boolean isSendSms() {
        return this.sendSms;
    }

    public void setSendSms(Boolean sendSms) {
        this.sendSms = sendSms;
    }

    public CreateDownloadShareRequest smsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  CSV string of recipient MSISDNs")
    public String getSmsRecipients() {
        return this.smsRecipients;
    }

    public void setSmsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDownloadShareRequest createDownloadShareRequest = (CreateDownloadShareRequest)o;
        return Objects.equals(this.nodeId, createDownloadShareRequest.nodeId) && Objects.equals(this.name, createDownloadShareRequest.name) && Objects.equals(this.password, createDownloadShareRequest.password) && Objects.equals(this.expiration, createDownloadShareRequest.expiration) && Objects.equals(this.notes, createDownloadShareRequest.notes) && Objects.equals(this.internalNotes, createDownloadShareRequest.internalNotes) && Objects.equals(this.showCreatorName, createDownloadShareRequest.showCreatorName) && Objects.equals(this.showCreatorUsername, createDownloadShareRequest.showCreatorUsername) && Objects.equals(this.maxDownloads, createDownloadShareRequest.maxDownloads) && Objects.equals(this.keyPair, createDownloadShareRequest.keyPair) && Objects.equals(this.fileKey, createDownloadShareRequest.fileKey) && Objects.equals(this.receiverLanguage, createDownloadShareRequest.receiverLanguage) && Objects.equals(this.textMessageRecipients, createDownloadShareRequest.textMessageRecipients) && Objects.equals(this.notifyCreator, createDownloadShareRequest.notifyCreator) && Objects.equals(this.creatorLanguage, createDownloadShareRequest.creatorLanguage) && Objects.equals(this.sendMail, createDownloadShareRequest.sendMail) && Objects.equals(this.mailRecipients, createDownloadShareRequest.mailRecipients) && Objects.equals(this.mailSubject, createDownloadShareRequest.mailSubject) && Objects.equals(this.mailBody, createDownloadShareRequest.mailBody) && Objects.equals(this.sendSms, createDownloadShareRequest.sendSms) && Objects.equals(this.smsRecipients, createDownloadShareRequest.smsRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.name, this.password, this.expiration, this.notes, this.internalNotes, this.showCreatorName, this.showCreatorUsername, this.maxDownloads, this.keyPair, this.fileKey, this.receiverLanguage, this.textMessageRecipients, this.notifyCreator, this.creatorLanguage, this.sendMail, this.mailRecipients, this.mailSubject, this.mailBody, this.sendSms, this.smsRecipients);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDownloadShareRequest {\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.nodeId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    internalNotes: ").append(this.toIndentedString(this.internalNotes)).append("\n");
        sb.append("    showCreatorName: ").append(this.toIndentedString(this.showCreatorName)).append("\n");
        sb.append("    showCreatorUsername: ").append(this.toIndentedString(this.showCreatorUsername)).append("\n");
        sb.append("    maxDownloads: ").append(this.toIndentedString(this.maxDownloads)).append("\n");
        sb.append("    keyPair: ").append(this.toIndentedString(this.keyPair)).append("\n");
        sb.append("    fileKey: ").append(this.toIndentedString(this.fileKey)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("    textMessageRecipients: ").append(this.toIndentedString(this.textMessageRecipients)).append("\n");
        sb.append("    notifyCreator: ").append(this.toIndentedString(this.notifyCreator)).append("\n");
        sb.append("    creatorLanguage: ").append(this.toIndentedString(this.creatorLanguage)).append("\n");
        sb.append("    sendMail: ").append(this.toIndentedString(this.sendMail)).append("\n");
        sb.append("    mailRecipients: ").append(this.toIndentedString(this.mailRecipients)).append("\n");
        sb.append("    mailSubject: ").append(this.toIndentedString(this.mailSubject)).append("\n");
        sb.append("    mailBody: ").append(this.toIndentedString(this.mailBody)).append("\n");
        sb.append("    sendSms: ").append(this.toIndentedString(this.sendSms)).append("\n");
        sb.append("    smsRecipients: ").append(this.toIndentedString(this.smsRecipients)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

