/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for configuring a room")
public class ConfigRoomRequest {
    @JsonProperty(value="recycleBinRetentionPeriod")
    private Integer recycleBinRetentionPeriod = null;
    @JsonProperty(value="inheritPermissions")
    private Boolean inheritPermissions = null;
    @JsonProperty(value="takeOverPermissions")
    private Boolean takeOverPermissions = null;
    @JsonProperty(value="adminIds")
    private List<Long> adminIds = null;
    @JsonProperty(value="adminGroupIds")
    private List<Long> adminGroupIds = null;
    @JsonProperty(value="newGroupMemberAcceptance")
    private NewGroupMemberAcceptanceEnum newGroupMemberAcceptance = NewGroupMemberAcceptanceEnum.AUTOALLOW;
    @JsonProperty(value="hasActivitiesLog")
    private Boolean hasActivitiesLog = true;
    @JsonProperty(value="classification")
    private ClassificationEnum classification = ClassificationEnum.NUMBER_2;
    @JsonProperty(value="hasRecycleBin")
    private Boolean hasRecycleBin = null;

    public ConfigRoomRequest recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
        return this;
    }

    @Schema(description="Retention period for deleted nodes in days")
    public Integer getRecycleBinRetentionPeriod() {
        return this.recycleBinRetentionPeriod;
    }

    public void setRecycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
    }

    public ConfigRoomRequest inheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
        return this;
    }

    @Schema(description="Inherit permissions from parent room  (default: `false` if `parentId` is `0`; otherwise: `true`)")
    public Boolean isInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public ConfigRoomRequest takeOverPermissions(Boolean takeOverPermissions) {
        this.takeOverPermissions = takeOverPermissions;
        return this;
    }

    @Schema(description="Take over existing permissions")
    public Boolean isTakeOverPermissions() {
        return this.takeOverPermissions;
    }

    public void setTakeOverPermissions(Boolean takeOverPermissions) {
        this.takeOverPermissions = takeOverPermissions;
    }

    public ConfigRoomRequest adminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
        return this;
    }

    public ConfigRoomRequest addAdminIdsItem(Long adminIdsItem) {
        if (this.adminIds == null) {
            this.adminIds = new ArrayList<Long>();
        }
        this.adminIds.add(adminIdsItem);
        return this;
    }

    @Schema(description="List of user ids  A room requires at least one admin (user or group)")
    public List<Long> getAdminIds() {
        return this.adminIds;
    }

    public void setAdminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
    }

    public ConfigRoomRequest adminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
        return this;
    }

    public ConfigRoomRequest addAdminGroupIdsItem(Long adminGroupIdsItem) {
        if (this.adminGroupIds == null) {
            this.adminGroupIds = new ArrayList<Long>();
        }
        this.adminGroupIds.add(adminGroupIdsItem);
        return this;
    }

    @Schema(description="List of group ids  A room requires at least one admin (user or group)")
    public List<Long> getAdminGroupIds() {
        return this.adminGroupIds;
    }

    public void setAdminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
    }

    public ConfigRoomRequest newGroupMemberAcceptance(NewGroupMemberAcceptanceEnum newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
        return this;
    }

    @Schema(description="Behaviour when new users are added to the group:  * `autoallow`  * `pending`    Only relevant if `adminGroupIds` has items.")
    public NewGroupMemberAcceptanceEnum getNewGroupMemberAcceptance() {
        return this.newGroupMemberAcceptance;
    }

    public void setNewGroupMemberAcceptance(NewGroupMemberAcceptanceEnum newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
    }

    public ConfigRoomRequest hasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
        return this;
    }

    @Schema(description="Is activities log active (for rooms only)")
    public Boolean isHasActivitiesLog() {
        return this.hasActivitiesLog;
    }

    public void setHasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
    }

    public ConfigRoomRequest classification(ClassificationEnum classification) {
        this.classification = classification;
        return this;
    }

    @Schema(description="Classification ID:  * `1` - public  * `2` - internal  * `3` - confidential  * `4` - strictly confidential    Provided (or default) classification is taken from room  when file gets uploaded without any classification.")
    public ClassificationEnum getClassification() {
        return this.classification;
    }

    public void setClassification(ClassificationEnum classification) {
        this.classification = classification;
    }

    public ConfigRoomRequest hasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.10.0  Is recycle bin active (for rooms only)  Recycle bin is always on (disabling is not possible).")
    public Boolean isHasRecycleBin() {
        return this.hasRecycleBin;
    }

    public void setHasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigRoomRequest configRoomRequest = (ConfigRoomRequest)o;
        return Objects.equals(this.recycleBinRetentionPeriod, configRoomRequest.recycleBinRetentionPeriod) && Objects.equals(this.inheritPermissions, configRoomRequest.inheritPermissions) && Objects.equals(this.takeOverPermissions, configRoomRequest.takeOverPermissions) && Objects.equals(this.adminIds, configRoomRequest.adminIds) && Objects.equals(this.adminGroupIds, configRoomRequest.adminGroupIds) && Objects.equals((Object)this.newGroupMemberAcceptance, (Object)configRoomRequest.newGroupMemberAcceptance) && Objects.equals(this.hasActivitiesLog, configRoomRequest.hasActivitiesLog) && Objects.equals((Object)this.classification, (Object)configRoomRequest.classification) && Objects.equals(this.hasRecycleBin, configRoomRequest.hasRecycleBin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recycleBinRetentionPeriod, this.inheritPermissions, this.takeOverPermissions, this.adminIds, this.adminGroupIds, this.newGroupMemberAcceptance, this.hasActivitiesLog, this.classification, this.hasRecycleBin});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfigRoomRequest {\n");
        sb.append("    recycleBinRetentionPeriod: ").append(this.toIndentedString(this.recycleBinRetentionPeriod)).append("\n");
        sb.append("    inheritPermissions: ").append(this.toIndentedString(this.inheritPermissions)).append("\n");
        sb.append("    takeOverPermissions: ").append(this.toIndentedString(this.takeOverPermissions)).append("\n");
        sb.append("    adminIds: ").append(this.toIndentedString(this.adminIds)).append("\n");
        sb.append("    adminGroupIds: ").append(this.toIndentedString(this.adminGroupIds)).append("\n");
        sb.append("    newGroupMemberAcceptance: ").append(this.toIndentedString((Object)this.newGroupMemberAcceptance)).append("\n");
        sb.append("    hasActivitiesLog: ").append(this.toIndentedString(this.hasActivitiesLog)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString((Object)this.classification)).append("\n");
        sb.append("    hasRecycleBin: ").append(this.toIndentedString(this.hasRecycleBin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NewGroupMemberAcceptanceEnum {
        AUTOALLOW("autoallow"),
        PENDING("pending");

        private String value;

        private NewGroupMemberAcceptanceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NewGroupMemberAcceptanceEnum fromValue(String text) {
            for (NewGroupMemberAcceptanceEnum b : NewGroupMemberAcceptanceEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ClassificationEnum {
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_3(3),
        NUMBER_4(4);

        private Integer value;

        private ClassificationEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClassificationEnum fromValue(Integer text) {
            for (ClassificationEnum b : ClassificationEnum.values()) {
                if (!b.value.equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

