/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.ActiveDirectoryAuthInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.ChunkUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteS3ShareUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateShareUploadChannelRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateShareUploadChannelResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneratePresignedUrlsRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.OpenIdAuthInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.PresignedUrlList;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicDownloadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicDownloadTokenGenerateRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicDownloadTokenGenerateResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicUploadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicUploadedFileData;
import ch.cyberduck.core.sds.io.swagger.client.model.S3ShareUploadStatus;
import ch.cyberduck.core.sds.io.swagger.client.model.SdsServerTime;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.io.swagger.client.model.SystemInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.ThirdPartyDependenciesData;
import ch.cyberduck.core.sds.io.swagger.client.model.UserFileKeyList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class PublicApi {
    private ApiClient apiClient;

    public PublicApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PublicApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelFileUploadViaShare(String accessKey, String uploadId) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling cancelFileUploadViaShare");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling cancelFileUploadViaShare");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}/{upload_id}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PublicUploadedFileData completeFileUploadViaShare(UserFileKeyList body, String accessKey, String uploadId, String xSdsDateFormat) throws ApiException {
        UserFileKeyList localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling completeFileUploadViaShare");
        }
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling completeFileUploadViaShare");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling completeFileUploadViaShare");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}/{upload_id}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicUploadedFileData> localVarReturnType = new GenericType<PublicUploadedFileData>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void completeS3FileUploadViaShare(CompleteS3ShareUploadRequest body, String accessKey, String uploadId) throws ApiException {
        CompleteS3ShareUploadRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling completeS3FileUploadViaShare");
        }
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling completeS3FileUploadViaShare");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling completeS3FileUploadViaShare");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}/{upload_id}/s3".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CreateShareUploadChannelResponse createShareUploadChannel(CreateShareUploadChannelRequest body, String accessKey) throws ApiException {
        CreateShareUploadChannelRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createShareUploadChannel");
        }
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling createShareUploadChannel");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<CreateShareUploadChannelResponse> localVarReturnType = new GenericType<CreateShareUploadChannelResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void downloadFileViaTokenPublic(String accessKey, String token, String range, Boolean genericMimetype, Boolean inline) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling downloadFileViaTokenPublic");
        }
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling downloadFileViaTokenPublic");
        }
        String localVarPath = "/v4/public/shares/downloads/{access_key}/{token}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "generic_mimetype", genericMimetype));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "inline", inline));
        if (range != null) {
            localVarHeaderParams.put("Range", this.apiClient.parameterToString(range));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void downloadFileViaTokenPublic1(String accessKey, String token, String range, Boolean genericMimetype, Boolean inline) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling downloadFileViaTokenPublic1");
        }
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling downloadFileViaTokenPublic1");
        }
        String localVarPath = "/v4/public/shares/downloads/{access_key}/{token}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "generic_mimetype", genericMimetype));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "inline", inline));
        if (range != null) {
            localVarHeaderParams.put("Range", this.apiClient.parameterToString(range));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "HEAD", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PublicDownloadTokenGenerateResponse generateDownloadUrlPublic(PublicDownloadTokenGenerateRequest body, String accessKey) throws ApiException {
        PublicDownloadTokenGenerateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling generateDownloadUrlPublic");
        }
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling generateDownloadUrlPublic");
        }
        String localVarPath = "/v4/public/shares/downloads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicDownloadTokenGenerateResponse> localVarReturnType = new GenericType<PublicDownloadTokenGenerateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PresignedUrlList generatePresignedUrlsPublic(GeneratePresignedUrlsRequest body, String accessKey, String uploadId, String xSdsDateFormat) throws ApiException {
        GeneratePresignedUrlsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling generatePresignedUrlsPublic");
        }
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling generatePresignedUrlsPublic");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling generatePresignedUrlsPublic");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}/{upload_id}/s3_urls".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PresignedUrlList> localVarReturnType = new GenericType<PresignedUrlList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ActiveDirectoryAuthInfo requestActiveDirectoryAuthInfo(Boolean isGlobalAvailable) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/public/system/info/auth/ad";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "is_global_available", isGlobalAvailable));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ActiveDirectoryAuthInfo> localVarReturnType = new GenericType<ActiveDirectoryAuthInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OpenIdAuthInfo requestOpenIdAuthInfo(Boolean isGlobalAvailable) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/public/system/info/auth/openid";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "is_global_available", isGlobalAvailable));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<OpenIdAuthInfo> localVarReturnType = new GenericType<OpenIdAuthInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PublicDownloadShare requestPublicDownloadShareInfo(String accessKey, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling requestPublicDownloadShareInfo");
        }
        String localVarPath = "/v4/public/shares/downloads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicDownloadShare> localVarReturnType = new GenericType<PublicDownloadShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PublicUploadShare requestPublicUploadShareInfo(String accessKey, String xSdsSharePassword, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling requestPublicUploadShareInfo");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsSharePassword != null) {
            localVarHeaderParams.put("X-Sds-Share-Password", this.apiClient.parameterToString(xSdsSharePassword));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<PublicUploadShare> localVarReturnType = new GenericType<PublicUploadShare>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SoftwareVersionData requestSoftwareVersion(String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/public/software/version";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SoftwareVersionData> localVarReturnType = new GenericType<SoftwareVersionData>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SystemInfo requestSystemInfo(Boolean isEnabled) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/public/system/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "is_enabled", isEnabled));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SystemInfo> localVarReturnType = new GenericType<SystemInfo>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SdsServerTime requestSystemTime(String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/public/time";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<SdsServerTime> localVarReturnType = new GenericType<SdsServerTime>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ThirdPartyDependenciesData> requestThirdPartyDependencies() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/public/software/third_party_dependencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<List<ThirdPartyDependenciesData>> localVarReturnType = new GenericType<List<ThirdPartyDependenciesData>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public S3ShareUploadStatus requestUploadStatusPublic(String accessKey, String uploadId) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling requestUploadStatusPublic");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling requestUploadStatusPublic");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}/{upload_id}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<S3ShareUploadStatus> localVarReturnType = new GenericType<S3ShareUploadStatus>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkUploadResponse uploadFileAsMultipartPublic1(String accessKey, String uploadId, File file, String contentRange, String xSdsDateFormat) throws ApiException {
        Object localVarPostBody = null;
        if (accessKey == null) {
            throw new ApiException(400, "Missing the required parameter 'accessKey' when calling uploadFileAsMultipartPublic1");
        }
        if (uploadId == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadId' when calling uploadFileAsMultipartPublic1");
        }
        String localVarPath = "/v4/public/shares/uploads/{access_key}/{upload_id}".replaceAll("\\{access_key\\}", this.apiClient.escapeString(accessKey.toString())).replaceAll("\\{upload_id\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentRange != null) {
            localVarHeaderParams.put("Content-Range", this.apiClient.parameterToString(contentRange));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ChunkUploadResponse> localVarReturnType = new GenericType<ChunkUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

