/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.DeletedNode;
import ch.cyberduck.core.sds.io.swagger.client.model.DeletedNodeVersionsList;
import ch.cyberduck.core.sds.io.swagger.client.model.RestoreDeletedNodesRequest;

public class SDSVersioningFeature
implements Versioning {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSVersioningFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public VersioningConfiguration getConfiguration(Path container) {
        return new VersioningConfiguration(true);
    }

    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        throw new UnsupportedException();
    }

    public void revert(Path file) throws BackgroundException {
        try {
            new NodesApi((ApiClient)this.session.getClient()).restoreNodes(new RestoreDeletedNodesRequest().resolutionStrategy(RestoreDeletedNodesRequest.ResolutionStrategyEnum.OVERWRITE).keepShareLinks(new HostPreferences(this.session.getHost()).getBoolean("sds.upload.sharelinks.keep")).addDeletedNodeIdsItem(Long.parseLong(this.nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener()))).parentId(Long.parseLong(this.nodeid.getVersionId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))), "");
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Failure to write attributes of {0}", e, file);
        }
    }

    public boolean isRevertable(Path file) {
        return true;
    }

    public AttributedList<Path> list(Path file, ListProgressListener listener) throws BackgroundException {
        int chunksize = new HostPreferences(this.session.getHost()).getInteger("sds.listing.chunksize");
        try {
            DeletedNodeVersionsList nodes;
            int offset = 0;
            AttributedList versions = new AttributedList();
            do {
                nodes = new NodesApi((ApiClient)this.session.getClient()).requestDeletedNodeVersions(Long.parseLong(this.nodeid.getVersionId(file.getParent(), (ListProgressListener)new DisabledListProgressListener())), file.isFile() ? "file" : "folder", file.getName(), "", "updatedAt:desc", offset, chunksize, null);
                for (DeletedNode item : nodes.getItems()) {
                    versions.add((Referenceable)new Path(file.getParent(), file.getName(), file.getType(), new SDSAttributesAdapter(this.session).toAttributes(item)));
                }
                offset += chunksize;
                listener.chunk(file.getParent(), versions);
            } while (nodes.getItems().size() == chunksize);
            return versions;
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Failure to read attributes of {0}", e, file);
        }
    }
}

