/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.sds.SDSSession;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class SDSUrlProvider
implements UrlProvider {
    private final SDSSession session;

    public SDSUrlProvider(SDSSession session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        String nodeid = file.attributes().getVersionId();
        if (StringUtils.isBlank((CharSequence)nodeid)) {
            return DescriptiveUrlBag.empty();
        }
        return new DescriptiveUrlBag(Collections.singletonList(new DescriptiveUrl(URI.create(String.format("%s/#/node/%s/details", new HostUrlProvider().withUsername(false).get(this.session.getHost()), URIEncoder.encode((String)nodeid))), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), this.session.getHost().getProtocol().getScheme().toString().toUpperCase(Locale.ROOT)))));
    }
}

