/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Version;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.TransferCanceledException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UploadsApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadStatus;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ScheduledThreadPool;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.InvalidKeyPairException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class SDSUploadService {
    private static final Logger log = LogManager.getLogger(SDSUploadService.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSUploadService(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public CreateFileUploadResponse start(Path file, TransferStatus status) throws BackgroundException {
        try {
            CreateFileUploadRequest body = new CreateFileUploadRequest().size(-1L == status.getLength() ? null : Long.valueOf(status.getLength())).parentId(Long.parseLong(this.nodeid.getVersionId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))).name(file.getName()).directS3Upload(null);
            if (status.getTimestamp() != null) {
                SoftwareVersionData version = this.session.softwareVersion();
                Matcher matcher = Pattern.compile("(([0-9]+)\\.([0-9]+)\\.([0-9]+)).*").matcher(version.getRestApiVersion());
                if (matcher.matches() && new Version(matcher.group(1)).compareTo(new Version("4.22")) >= 0) {
                    body.timestampModification(new DateTime((Object)status.getTimestamp()));
                }
            }
            return new NodesApi((ApiClient)this.session.getClient()).createFileUploadChannel(body, "");
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Upload {0} failed", e, file);
        }
    }

    public Node complete(Path file, String uploadToken, TransferStatus status) throws BackgroundException {
        try {
            Checksum server;
            Checksum checksum;
            Node upload;
            CompleteUploadRequest body = new CompleteUploadRequest().keepShareLinks(new HostPreferences(this.session.getHost()).getBoolean("sds.upload.sharelinks.keep")).resolutionStrategy(CompleteUploadRequest.ResolutionStrategyEnum.OVERWRITE);
            if (status.getFilekey() != null) {
                ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                FileKey fileKey = (FileKey)reader.readValue(status.getFilekey().array());
                EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(this.session.keyPair().getPublicKeyContainer()));
                body.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
            }
            if (!(upload = new UploadsApi((ApiClient)this.session.getClient()).completeFileUploadByToken(body, uploadToken, "")).isIsEncrypted().booleanValue() && Checksum.NONE != (checksum = status.getChecksum()) && Checksum.NONE != (server = Checksum.parse((String)upload.getHash())) && checksum.algorithm.equals((Object)server.algorithm) && !server.equals((Object)checksum)) {
                throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", checksum.hash, server.hash));
            }
            this.nodeid.cache(file, String.valueOf(upload.getId()));
            return upload;
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Upload {0} failed", e, file);
        }
        catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException | UnknownVersionException e) {
            throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public void cancel(Path file, String uploadToken) throws BackgroundException {
        log.warn(String.format("Cancel failed upload %s for %s", uploadToken, file));
        try {
            new UploadsApi((ApiClient)this.session.getClient()).cancelFileUploadByToken(uploadToken);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Upload {0} failed", e, file);
        }
    }

    public S3FileUploadStatus await(Path file, TransferStatus status, String uploadId) throws BackgroundException {
        final CountDownLatch signal = new CountDownLatch(1);
        AtomicReference response = new AtomicReference();
        final AtomicReference<TransferCanceledException> failure = new AtomicReference<TransferCanceledException>();
        ScheduledThreadPool polling = new ScheduledThreadPool((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                super.uncaughtException(t, e);
                failure.set(new BackgroundException(e));
                signal.countDown();
            }
        });
        AtomicLong polls = new AtomicLong();
        ScheduledFuture f = polling.repeat(() -> {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Query upload status for %s (%d)", uploadId, polls.incrementAndGet()));
                }
                S3FileUploadStatus uploadStatus = new NodesApi((ApiClient)this.session.getClient()).requestUploadStatusFiles(uploadId, "", null);
                response.set(uploadStatus);
                switch (uploadStatus.getStatus()) {
                    case "finishing": {
                        break;
                    }
                    case "transfer": {
                        failure.set((TransferCanceledException)new InteroperabilityException(uploadStatus.getStatus()));
                        signal.countDown();
                        break;
                    }
                    case "error": {
                        log.warn(String.format("Error polling for upload status of %s (%d)", file, polls.incrementAndGet()));
                        if (null == uploadStatus.getErrorDetails()) {
                            log.warn(String.format("Missing error details for upload status %s", uploadStatus));
                            failure.set((TransferCanceledException)new InteroperabilityException());
                        } else {
                            failure.set((TransferCanceledException)new InteroperabilityException(uploadStatus.getErrorDetails().getMessage()));
                        }
                        signal.countDown();
                        break;
                    }
                    case "done": {
                        this.nodeid.cache(file, String.valueOf(uploadStatus.getNode().getId()));
                        status.withResponse(new SDSAttributesAdapter(this.session).toAttributes(uploadStatus.getNode())).setComplete();
                        signal.countDown();
                    }
                }
            }
            catch (ApiException e) {
                failure.set((TransferCanceledException)new SDSExceptionMappingService(this.nodeid).map("Upload {0} failed", e, file));
                signal.countDown();
            }
        }, new HostPreferences(this.session.getHost()).getLong("sds.upload.s3.status.delay"), Long.valueOf(new HostPreferences(this.session.getHost()).getLong("sds.upload.s3.status.period")), TimeUnit.MILLISECONDS);
        long timeout = new HostPreferences(this.session.getHost()).getLong("sds.upload.s3.status.interrupt.ms");
        long start = System.currentTimeMillis();
        while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal, (Duration)Duration.ofSeconds(1L))) {
            try {
                if (f.isDone()) {
                    Uninterruptibles.getUninterruptibly((Future)f);
                }
                if (System.currentTimeMillis() - start <= timeout) continue;
                log.error(String.format("Cancel polling for upload status of %s after %dms (%d)", file, System.currentTimeMillis() - start, polls.get()));
                failure.set(new TransferCanceledException((Throwable)new ConnectionTimeoutException(file.getAbsolute())));
                signal.countDown();
            }
            catch (ExecutionException e) {
                Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
            }
        }
        polling.shutdown();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Polling completed for %s with %d polls in %dms ", file, polls.get(), System.currentTimeMillis() - start));
        }
        if (null != failure.get()) {
            throw (BackgroundException)((Object)failure.get());
        }
        status.setComplete();
        return (S3FileUploadStatus)response.get();
    }
}

