/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Encryptor;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptEncryptingInputStream;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSTripleCryptEncryptorFeature
implements Encryptor {
    private static final Logger log = LogManager.getLogger(SDSTripleCryptEncryptorFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSTripleCryptEncryptorFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public InputStream encrypt(Path file, InputStream proxy, TransferStatus status) throws BackgroundException {
        try {
            ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Read file key for file %s", file));
            }
            if (null == status.getFilekey()) {
                status.setFilekey(this.nodeid.getFileKey());
            }
            FileKey fileKey = (FileKey)reader.readValue(status.getFilekey().array());
            return new TripleCryptEncryptingInputStream(this.session, proxy, Crypto.createFileEncryptionCipher((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey)), status);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
        catch (CryptoSystemException | UnknownVersionException e) {
            throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }
}

