/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSDelegatingWriteFeature;
import ch.cyberduck.core.sds.SDSDirectS3MultipartWriteFeature;
import ch.cyberduck.core.sds.SDSMultipartWriteFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.shared.DefaultTouchFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSTouchFeature
extends DefaultTouchFeature<Node> {
    private static final Logger log = LogManager.getLogger(SDSTouchFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSTouchFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        super((Write)new SDSDelegatingWriteFeature(session, nodeid, (Write<Node>)(new HostPreferences(session.getHost()).getBoolean("sds.upload.s3.enable") ? new SDSDirectS3MultipartWriteFeature(session, nodeid) : new SDSMultipartWriteFeature(session, nodeid))));
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (SDSNodeIdProvider.isEncrypted(file)) {
            status.setFilekey(this.nodeid.getFileKey());
        }
        return super.touch(file, status);
    }

    public boolean isSupported(Path workdir, String filename) {
        if (workdir.isRoot()) {
            return false;
        }
        if (!this.validate(filename)) {
            log.warn(String.format("Validation failed for target name %s", filename));
            return false;
        }
        if (workdir.attributes().getQuota() != -1L && workdir.attributes().getQuota() <= workdir.attributes().getSize() + (long)new HostPreferences(this.session.getHost()).getInteger("sds.upload.multipart.chunksize")) {
            log.warn(String.format("Quota %d exceeded with %d in %s", workdir.attributes().getQuota(), workdir.attributes().getSize(), workdir));
            return false;
        }
        SDSPermissionsFeature permissions = new SDSPermissionsFeature(this.session, this.nodeid);
        return permissions.containsRole(workdir, SDSPermissionsFeature.CREATE_ROLE) && permissions.containsRole(workdir, SDSPermissionsFeature.DELETE_ROLE);
    }

    public boolean validate(String filename) {
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            if (StringUtils.length((CharSequence)filename) > 150) {
                return false;
            }
            if (StringUtils.containsAny((CharSequence)filename, (char[])new char[]{'\\', '<', '>', ':', '\"', '|', '?', '*', '/'})) {
                return false;
            }
            if (StringUtils.startsWith((CharSequence)filename, (CharSequence)"-")) {
                return false;
            }
            if (StringUtils.endsWith((CharSequence)filename, (CharSequence)".")) {
                return false;
            }
        }
        return true;
    }
}

