/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Version;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateFileRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateFolderRequest;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class SDSTimestampFeature
extends DefaultTimestampFeature {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSTimestampFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        try {
            SoftwareVersionData version = this.session.softwareVersion();
            Matcher matcher = Pattern.compile("(([0-9]+)\\.([0-9]+)\\.([0-9]+)).*").matcher(version.getRestApiVersion());
            if (matcher.matches() && new Version(matcher.group(1)).compareTo(new Version("4.22")) < 0) {
                throw new UnsupportedException();
            }
            if (file.isDirectory()) {
                new NodesApi((ApiClient)this.session.getClient()).updateFolder(new UpdateFolderRequest().timestampModification(new DateTime((Object)status.getTimestamp())), Long.parseLong(this.nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener())), "", null);
            } else {
                new NodesApi((ApiClient)this.session.getClient()).updateFile(new UpdateFileRequest().timestampModification(new DateTime((Object)status.getTimestamp())), Long.parseLong(this.nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener())), "", null);
            }
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Failure to write attributes of {0}", e, file);
        }
    }
}

