/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.sds.SDSBatchDeleteFeature;
import ch.cyberduck.core.sds.SDSDeleteFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class SDSThresholdDeleteFeature
implements Delete {
    private final SDSSession session;
    private final SDSNodeIdProvider fileid;

    public SDSThresholdDeleteFeature(SDSSession session, SDSNodeIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        if (files.size() == 1) {
            new SDSDeleteFeature(this.session, this.fileid).delete(files, prompt, callback);
        } else {
            new SDSBatchDeleteFeature(this.session, this.fileid).delete(files, prompt, callback);
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

