/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionTimeoutFactory;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ExpiringObjectHolder;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.Version;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Encryptor;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.VersionIdProvider;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.jersey.HttpComponentsProvider;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesReader;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSCopyFeature;
import ch.cyberduck.core.sds.SDSDelegatingCopyFeature;
import ch.cyberduck.core.sds.SDSDelegatingMoveFeature;
import ch.cyberduck.core.sds.SDSDelegatingReadFeature;
import ch.cyberduck.core.sds.SDSDelegatingWriteFeature;
import ch.cyberduck.core.sds.SDSDirectS3MultipartWriteFeature;
import ch.cyberduck.core.sds.SDSDirectS3UploadFeature;
import ch.cyberduck.core.sds.SDSDirectS3WriteFeature;
import ch.cyberduck.core.sds.SDSDirectoryFeature;
import ch.cyberduck.core.sds.SDSEncryptionBulkFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSFindFeature;
import ch.cyberduck.core.sds.SDSListService;
import ch.cyberduck.core.sds.SDSMoveFeature;
import ch.cyberduck.core.sds.SDSMultipartWriteFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSProtocol;
import ch.cyberduck.core.sds.SDSQuotaFeature;
import ch.cyberduck.core.sds.SDSReadFeature;
import ch.cyberduck.core.sds.SDSSearchFeature;
import ch.cyberduck.core.sds.SDSSharesUrlProvider;
import ch.cyberduck.core.sds.SDSThresholdDeleteFeature;
import ch.cyberduck.core.sds.SDSTimestampFeature;
import ch.cyberduck.core.sds.SDSTouchFeature;
import ch.cyberduck.core.sds.SDSTripleCryptEncryptorFeature;
import ch.cyberduck.core.sds.SDSUrlProvider;
import ch.cyberduck.core.sds.SDSVersioningFeature;
import ch.cyberduck.core.sds.UserAccountWrapper;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.JSON;
import ch.cyberduck.core.sds.io.swagger.client.api.ConfigApi;
import ch.cyberduck.core.sds.io.swagger.client.api.PublicApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UserApi;
import ch.cyberduck.core.sds.io.swagger.client.model.AlgorithmVersionInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.AlgorithmVersionInfoList;
import ch.cyberduck.core.sds.io.swagger.client.model.ClassificationPoliciesConfig;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateKeyPairRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneralSettingsInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.io.swagger.client.model.SystemDefaults;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAccount;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import ch.cyberduck.core.shared.DefaultUploadFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.migcomponents.migbase64.Base64;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.internal.InputStreamProvider;

public class SDSSession
extends HttpSession<SDSApiClient> {
    private static final Logger log = LogManager.getLogger(SDSSession.class);
    public static final String SDS_AUTH_TOKEN_HEADER = "X-Sds-Auth-Token";
    public static final int DEFAULT_CHUNKSIZE = 16;
    public static final String VERSION_REGEX = "(([0-9]+)\\.([0-9]+)\\.([0-9]+)).*";
    protected OAuth2RequestInterceptor authorizationService;
    private final PreferencesReader preferences;
    private final ExpiringObjectHolder<UserAccountWrapper> userAccount;
    private final ExpiringObjectHolder<UserKeyPairContainer> keyPair;
    private final ExpiringObjectHolder<UserKeyPairContainer> keyPairDeprecated;
    private final ExpiringObjectHolder<SystemDefaults> systemDefaults;
    private final ExpiringObjectHolder<GeneralSettingsInfo> generalSettingsInfo;
    private final ExpiringObjectHolder<ClassificationPoliciesConfig> classificationPolicies;
    private final ExpiringObjectHolder<SoftwareVersionData> softwareVersion;
    private UserKeyPair.Version requiredKeyPairVersion;
    private final SDSNodeIdProvider nodeid;

    public SDSSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
        this.preferences = new HostPreferences(this.host);
        this.userAccount = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("sds.useracount.ttl")));
        this.keyPair = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("sds.encryption.keys.ttl")));
        this.keyPairDeprecated = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("sds.encryption.keys.ttl")));
        this.systemDefaults = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("sds.useracount.ttl")));
        this.generalSettingsInfo = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("sds.useracount.ttl")));
        this.classificationPolicies = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("sds.useracount.ttl")));
        this.softwareVersion = new ExpiringObjectHolder(Long.valueOf(this.preferences.getLong("sds.useracount.ttl")));
        this.nodeid = new SDSNodeIdProvider(this);
    }

    protected SDSApiClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                HttpRequestWrapper wrapper;
                if (request instanceof HttpRequestWrapper && null != (wrapper = (HttpRequestWrapper)request).getTarget() && StringUtils.equals((CharSequence)wrapper.getTarget().getHostName(), (CharSequence)SDSSession.this.host.getHostname())) {
                    request.addHeader("Authorization", String.format("Basic %s", Base64.encodeToString((byte[])String.format("%s:%s", SDSSession.this.host.getProtocol().getOAuthClientId(), SDSSession.this.host.getProtocol().getOAuthClientSecret()).getBytes(StandardCharsets.UTF_8), (boolean)false)));
                }
            }
        }).build(), this.host){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                HttpRequestWrapper wrapper;
                if (request instanceof HttpRequestWrapper && null != (wrapper = (HttpRequestWrapper)request).getTarget() && StringUtils.equals((CharSequence)wrapper.getTarget().getHostName(), (CharSequence)SDSSession.this.host.getHostname())) {
                    super.process(request, context);
                }
            }
        }.withRedirectUri(OAuth2AuthorizationService.CYBERDUCK_REDIRECT_URI.equals(this.host.getProtocol().getOAuthRedirectUrl()) ? this.host.getProtocol().getOAuthRedirectUrl() : (Scheme.isURL((String)this.host.getProtocol().getOAuthRedirectUrl()) ? this.host.getProtocol().getOAuthRedirectUrl() : new HostUrlProvider().withUsername(false).withPath(true).get(this.host.getProtocol().getScheme(), this.host.getPort(), null, this.host.getHostname(), this.host.getProtocol().getOAuthRedirectUrl())));
        try {
            this.authorizationService.withParameter("user_agent_info", Base64.encodeToString((byte[])InetAddress.getLocalHost().getHostName().getBytes(StandardCharsets.UTF_8), (boolean)false));
        }
        catch (UnknownHostException e) {
            throw new DefaultIOExceptionMappingService().map((IOException)e);
        }
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                request.removeHeaders(SDSSession.SDS_AUTH_TOKEN_HEADER);
            }
        });
        CloseableHttpClient apache = configuration.build();
        SDSApiClient client = new SDSApiClient(apache);
        client.setBasePath(new HostUrlProvider().withUsername(false).withPath(true).get(this.host.getProtocol().getScheme(), this.host.getPort(), null, this.host.getHostname(), this.host.getProtocol().getContext()));
        client.setHttpClient(ClientBuilder.newClient((Configuration)new ClientConfig().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true).register((Object)new InputStreamProvider()).register(MultiPartFeature.class).register((Object)new JSON()).register(JacksonFeature.class).connectorProvider((ConnectorProvider)new HttpComponentsProvider(apache))));
        int timeout = ConnectionTimeoutFactory.get((PreferencesReader)this.preferences).getTimeout() * 1000;
        client.setConnectTimeout(timeout);
        client.setReadTimeout(timeout);
        client.setUserAgent(new PreferencesUseragentProvider().get());
        return client;
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        UserAccount account;
        SoftwareVersionData version = this.softwareVersion();
        Matcher matcher = Pattern.compile(VERSION_REGEX).matcher(version.getRestApiVersion());
        if (matcher.matches() && new Version(matcher.group(1)).compareTo(new Version(this.preferences.getProperty("sds.version.lts"))) < 0) {
            throw new InteroperabilityException(LocaleFactory.localizedString((String)"DRACOON environment needs to be updated", (String)"SDS"), LocaleFactory.localizedString((String)"Your DRACOON environment is outdated and no longer works with this application. Please contact your administrator.", (String)"SDS"));
        }
        Credentials credentials = this.host.getCredentials();
        switch (SDSProtocol.Authorization.valueOf(this.host.getProtocol().getAuthorization())) {
            case oauth: 
            case password: {
                if ("x-dracoon-action:oauth".equals(OAuth2AuthorizationService.CYBERDUCK_REDIRECT_URI)) {
                    if (matcher.matches()) {
                        if (new Version(matcher.group(1)).compareTo(new Version("4.15.0")) >= 0) {
                            this.authorizationService.withRedirectUri(OAuth2AuthorizationService.CYBERDUCK_REDIRECT_URI);
                        }
                    } else {
                        log.warn(String.format("Failure to parse software version %s", version));
                    }
                }
                this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel, SDSProtocol.Authorization.valueOf(this.host.getProtocol().getAuthorization()) == SDSProtocol.Authorization.password ? OAuth2AuthorizationService.FlowType.PasswordGrant : OAuth2AuthorizationService.FlowType.AuthorizationCode));
            }
        }
        try {
            account = new UserApi((ApiClient)this.client).requestUserInfo("", false, null);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Authenticated as user %s", account));
            }
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map(e);
        }
        switch (SDSProtocol.Authorization.valueOf(this.host.getProtocol().getAuthorization())) {
            case oauth: {
                credentials.setUsername(account.getLogin());
                credentials.setSaved(true);
            }
        }
        this.userAccount.set((Object)new UserAccountWrapper(account));
        this.requiredKeyPairVersion = this.getRequiredKeyPairVersion();
        this.unlockTripleCryptKeyPair(prompt, (UserAccountWrapper)this.userAccount.get(), this.requiredKeyPairVersion);
        this.updateDirectS3UploadSetting();
    }

    private void updateDirectS3UploadSetting() {
        boolean isS3DirectUploadSupported = false;
        try {
            Matcher matcher;
            if (this.generalSettingsInfo().isUseS3Storage().booleanValue() && (matcher = Pattern.compile(VERSION_REGEX).matcher(this.softwareVersion().getRestApiVersion())).matches()) {
                isS3DirectUploadSupported = new Version(matcher.group(1)).compareTo(new Version("4.22")) >= 0;
            }
        }
        catch (BackgroundException e) {
            log.warn(String.format("Failure reading software version. %s", e.getMessage()));
            isS3DirectUploadSupported = true;
        }
        this.host.setProperty("sds.upload.s3.enable", String.valueOf(isS3DirectUploadSupported));
    }

    private UserKeyPair.Version getRequiredKeyPairVersion() {
        try {
            AlgorithmVersionInfoList algorithms = new ConfigApi((ApiClient)this.client).requestAlgorithms(null);
            List<AlgorithmVersionInfo> keyPairAlgorithms = algorithms.getKeyPairAlgorithms();
            for (AlgorithmVersionInfo kpa : keyPairAlgorithms) {
                if (kpa.getStatus() != AlgorithmVersionInfo.StatusEnum.REQUIRED) continue;
                return UserKeyPair.Version.getByValue((String)kpa.getVersion());
            }
            log.error("No available key pair algorithm with status required found.");
        }
        catch (ApiException e) {
            log.warn(String.format("Ignore failure reading key pair version. %s", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
        }
        catch (UnknownVersionException e) {
            log.warn(String.format("Ignore failure reading required key pair algorithm. %s", new Object[]{new TripleCryptExceptionMappingService().map((CryptoException)((Object)e))}));
        }
        return UserKeyPair.Version.RSA2048;
    }

    private boolean isNewCryptoAvailable() throws BackgroundException {
        Matcher matcher = Pattern.compile(VERSION_REGEX).matcher(this.softwareVersion().getRestApiVersion());
        if (matcher.matches()) {
            return new Version(matcher.group(1)).compareTo(new Version("4.24.0")) >= 0;
        }
        return false;
    }

    protected void unlockTripleCryptKeyPair(LoginCallback prompt, UserAccountWrapper user, UserKeyPair.Version requiredKeyPairVersion) throws BackgroundException {
        try {
            Credentials deprecatedCredentials = null;
            if (this.isNewCryptoAvailable()) {
                UserKeyPair keypair;
                UserKeyPairContainer deprecated;
                List<UserKeyPairContainer> pairs = new UserApi((ApiClient)this.client).requestUserKeyPairs("", null);
                if (pairs.size() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("No keypair found for user %s", user));
                    }
                    return;
                }
                boolean migrated = false;
                for (UserKeyPairContainer pair : pairs) {
                    if (requiredKeyPairVersion != TripleCryptConverter.toCryptoUserKeyPair(pair).getUserPublicKey().getVersion()) continue;
                    migrated = true;
                    break;
                }
                if (migrated && pairs.size() == 2) {
                    deprecated = new UserApi((ApiClient)this.client).requestUserKeyPair("", UserKeyPair.Version.RSA2048.getValue(), null);
                    keypair = TripleCryptConverter.toCryptoUserKeyPair(deprecated);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Attempt to unlock deprecated private key %s", keypair.getUserPrivateKey()));
                    }
                    deprecatedCredentials = new TripleCryptKeyPair().unlock((PasswordCallback)prompt, this.host, keypair);
                    this.keyPairDeprecated.set((Object)deprecated);
                }
                if (!migrated) {
                    deprecated = new UserApi((ApiClient)this.client).requestUserKeyPair("", UserKeyPair.Version.RSA2048.getValue(), null);
                    keypair = TripleCryptConverter.toCryptoUserKeyPair(deprecated);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Attempt to unlock and migrate deprecated private key %s", keypair.getUserPrivateKey()));
                    }
                    deprecatedCredentials = new TripleCryptKeyPair().unlock((PasswordCallback)prompt, this.host, keypair);
                    UserKeyPair newPair = Crypto.generateUserKeyPair((UserKeyPair.Version)requiredKeyPairVersion, (String)deprecatedCredentials.getPassword());
                    CreateKeyPairRequest request = new CreateKeyPairRequest();
                    request.setPreviousPrivateKey(deprecated.getPrivateKeyContainer());
                    UserKeyPairContainer userKeyPairContainer = TripleCryptConverter.toSwaggerUserKeyPairContainer(newPair);
                    request.setPrivateKeyContainer(userKeyPairContainer.getPrivateKeyContainer());
                    request.setPublicKeyContainer(userKeyPairContainer.getPublicKeyContainer());
                    if (log.isDebugEnabled()) {
                        log.debug("Create new key pair");
                    }
                    new UserApi((ApiClient)this.client).createAndPreserveUserKeyPair(request, null);
                    this.keyPairDeprecated.set((Object)deprecated);
                }
            }
            UserKeyPairContainer container = new UserApi((ApiClient)this.client).requestUserKeyPair("", requiredKeyPairVersion.getValue(), null);
            this.keyPair.set((Object)container);
            UserKeyPair keypair = TripleCryptConverter.toCryptoUserKeyPair((UserKeyPairContainer)this.keyPair.get());
            if (deprecatedCredentials != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Attempt to unlock private key with passphrase from deprecated private key %s", keypair.getUserPrivateKey()));
                }
                if (Crypto.checkUserKeyPair((UserKeyPair)keypair, (String)deprecatedCredentials.getPassword())) {
                    new TripleCryptKeyPair().unlock((PasswordCallback)prompt, this.host, keypair, deprecatedCredentials.getPassword());
                } else {
                    new TripleCryptKeyPair().unlock((PasswordCallback)prompt, this.host, keypair);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Attempt to unlock private key %s", keypair.getUserPrivateKey()));
                }
                new TripleCryptKeyPair().unlock((PasswordCallback)prompt, this.host, keypair);
            }
        }
        catch (CryptoException e) {
            throw new TripleCryptExceptionMappingService().map(e);
        }
        catch (ApiException e) {
            log.warn(String.format("Ignore failure unlocking user key pair. %s", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
        }
        catch (LoginCanceledException e) {
            log.warn("Ignore cancel unlocking triple crypt private key pair");
        }
    }

    public void resetUserKeyPairs() {
        this.keyPair.set(null);
        this.keyPairDeprecated.set(null);
    }

    public UserAccountWrapper userAccount() throws BackgroundException {
        if (this.userAccount.get() == null) {
            try {
                this.userAccount.set((Object)new UserAccountWrapper(new UserApi((ApiClient)this.client).requestUserInfo("", false, null)));
            }
            catch (ApiException e) {
                log.warn(String.format("Failure updating user info. %s", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
                throw new SDSExceptionMappingService(this.nodeid).map(e);
            }
        }
        return (UserAccountWrapper)this.userAccount.get();
    }

    public UserKeyPairContainer getKeyPairForFileKey(EncryptedFileKey.Version version) throws BackgroundException {
        switch (version) {
            case RSA2048_AES256GCM: {
                UserKeyPairContainer keyPairDeprecated = this.keyPairDeprecated();
                if (null == keyPairDeprecated) {
                    throw new InteroperabilityException(String.format("No keypair for version %s", version));
                }
                return keyPairDeprecated;
            }
            case RSA4096_AES256GCM: {
                return this.keyPair();
            }
        }
        throw new InteroperabilityException(String.format("Unknown version %s", version));
    }

    public UserKeyPairContainer keyPairDeprecated() throws BackgroundException {
        if (this.keyPairDeprecated.get() == null) {
            try {
                this.keyPairDeprecated.set((Object)new UserApi((ApiClient)this.client).requestUserKeyPair("", UserKeyPair.Version.RSA2048.getValue(), null));
            }
            catch (ApiException e) {
                if (e.getCode() == 404) {
                    log.debug(String.format("User does not have a keypair for version %s", UserKeyPair.Version.RSA2048.getValue()));
                }
                log.warn(String.format("Failure updating user key pair. %s", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
                throw new SDSExceptionMappingService(this.nodeid).map(e);
            }
        }
        return (UserKeyPairContainer)this.keyPairDeprecated.get();
    }

    public UserKeyPairContainer keyPair() throws BackgroundException {
        if (this.keyPair.get() == null) {
            try {
                this.keyPair.set((Object)new UserApi((ApiClient)this.client).requestUserKeyPair("", this.requiredKeyPairVersion.getValue(), null));
            }
            catch (ApiException e) {
                log.warn(String.format("Failure updating user key pair for required algorithm. %s", e.getMessage()));
                UserKeyPairContainer keyPairDeprecated = this.keyPairDeprecated();
                if (null == keyPairDeprecated) {
                    throw new SDSExceptionMappingService(this.nodeid).map(e);
                }
                this.keyPair.set((Object)keyPairDeprecated);
            }
        }
        return (UserKeyPairContainer)this.keyPair.get();
    }

    public SoftwareVersionData softwareVersion() throws BackgroundException {
        if (this.softwareVersion.get() == null) {
            try {
                this.softwareVersion.set((Object)new PublicApi((ApiClient)this.client).requestSoftwareVersion(null));
                if (log.isInfoEnabled()) {
                    log.info(String.format("Server version %s", this.softwareVersion.get()));
                }
            }
            catch (ApiException e) {
                log.warn(String.format("Failure %s updating software version", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
                throw new SDSExceptionMappingService(this.nodeid).map(e);
            }
        }
        return (SoftwareVersionData)this.softwareVersion.get();
    }

    public SystemDefaults systemDefaults() throws BackgroundException {
        if (this.systemDefaults.get() == null) {
            try {
                this.systemDefaults.set((Object)new ConfigApi((ApiClient)this.client).requestSystemDefaultsInfo(""));
            }
            catch (ApiException e) {
                log.warn(String.format("Failure %s reading system defaults", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
                throw new SDSExceptionMappingService(this.nodeid).map(e);
            }
        }
        return (SystemDefaults)this.systemDefaults.get();
    }

    public GeneralSettingsInfo generalSettingsInfo() throws BackgroundException {
        if (this.generalSettingsInfo.get() == null) {
            try {
                this.generalSettingsInfo.set((Object)new ConfigApi((ApiClient)this.client).requestGeneralSettingsInfo(""));
            }
            catch (ApiException e) {
                log.warn(String.format("Failure %s reading configuration", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
                throw new SDSExceptionMappingService(this.nodeid).map(e);
            }
        }
        return (GeneralSettingsInfo)this.generalSettingsInfo.get();
    }

    public ClassificationPoliciesConfig shareClassificationsPolicies() throws BackgroundException {
        Matcher matcher;
        if (this.classificationPolicies.get() == null && (matcher = Pattern.compile(VERSION_REGEX).matcher(this.softwareVersion().getRestApiVersion())).matches() && new Version(matcher.group(1)).compareTo(new Version("4.30")) >= 0) {
            try {
                this.classificationPolicies.set((Object)new ConfigApi((ApiClient)this.client).requestClassificationPoliciesConfigInfo(""));
            }
            catch (ApiException e) {
                log.warn(String.format("Failure %s reading configuration", new Object[]{new SDSExceptionMappingService(this.nodeid).map(e)}));
                throw new SDSExceptionMappingService(this.nodeid).map(e);
            }
        }
        return (ClassificationPoliciesConfig)this.classificationPolicies.get();
    }

    public UserKeyPair.Version requiredKeyPairVersion() {
        return this.requiredKeyPairVersion;
    }

    protected void logout() {
        ((SDSApiClient)this.client).getHttpClient().close();
        this.nodeid.clear();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SDSListService(this, this.nodeid);
        }
        if (type == Read.class) {
            return (T)new SDSDelegatingReadFeature(this, this.nodeid, new SDSReadFeature(this, this.nodeid));
        }
        if (type == Upload.class) {
            if (new HostPreferences(this.host).getBoolean("sds.upload.s3.enable")) {
                return (T)((Object)new SDSDirectS3UploadFeature(this, this.nodeid, (Write<Node>)new SDSDirectS3WriteFeature(this, this.nodeid)));
            }
            return (T)new DefaultUploadFeature((Write)new SDSDelegatingWriteFeature(this, this.nodeid, (Write<Node>)new SDSMultipartWriteFeature(this, this.nodeid)));
        }
        if (type == Write.class || type == MultipartWrite.class) {
            if (new HostPreferences(this.host).getBoolean("sds.upload.s3.enable")) {
                return (T)new SDSDelegatingWriteFeature(this, this.nodeid, (Write<Node>)new SDSDirectS3MultipartWriteFeature(this, this.nodeid));
            }
            return (T)new SDSDelegatingWriteFeature(this, this.nodeid, (Write<Node>)new SDSMultipartWriteFeature(this, this.nodeid));
        }
        if (type == Directory.class) {
            return (T)new SDSDirectoryFeature(this, this.nodeid);
        }
        if (type == Delete.class) {
            return (T)new SDSThresholdDeleteFeature(this, this.nodeid);
        }
        if (type == VersionIdProvider.class) {
            return (T)((Object)this.nodeid);
        }
        if (type == Touch.class) {
            return (T)((Object)new SDSTouchFeature(this, this.nodeid));
        }
        if (type == Find.class) {
            return (T)new SDSFindFeature(this, this.nodeid);
        }
        if (type == AttributesFinder.class) {
            return (T)new SDSAttributesFinderFeature(this, this.nodeid);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new SDSTimestampFeature(this, this.nodeid));
        }
        if (type == Move.class) {
            return (T)new SDSDelegatingMoveFeature(this, this.nodeid, new SDSMoveFeature(this, this.nodeid));
        }
        if (type == Copy.class) {
            return (T)new SDSDelegatingCopyFeature(this, this.nodeid, new SDSCopyFeature(this, this.nodeid));
        }
        if (type == Bulk.class) {
            return (T)new SDSEncryptionBulkFeature(this, this.nodeid);
        }
        if (type == UrlProvider.class) {
            return (T)new SDSUrlProvider(this);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new SDSSharesUrlProvider(this, this.nodeid);
        }
        if (type == Quota.class) {
            return (T)new SDSQuotaFeature(this, this.nodeid);
        }
        if (type == Search.class) {
            return (T)new SDSSearchFeature(this, this.nodeid);
        }
        if (type == Versioning.class) {
            return (T)new SDSVersioningFeature(this, this.nodeid);
        }
        if (type == Encryptor.class) {
            return (T)new SDSTripleCryptEncryptorFeature(this, this.nodeid);
        }
        return (T)super._getFeature(type);
    }
}

