/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.DownloadTokenGenerateResponse;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(SDSReadFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSReadFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            SDSApiClient client = (SDSApiClient)this.session.getClient();
            DownloadTokenGenerateResponse token = new NodesApi((ApiClient)this.session.getClient()).generateDownloadUrl(Long.valueOf(this.nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener())), "");
            HttpGet request = new HttpGet(token.getDownloadUrl());
            request.addHeader("X-Sds-Auth-Token", "");
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add range header %s for file %s", header, file));
                }
                request.addHeader((Header)new BasicHeader("Range", header));
                request.addHeader((Header)new BasicHeader("Accept-Encoding", "identity"));
            }
            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 206: {
                    return new HttpMethodReleaseInputStream((HttpResponse)response, status);
                }
                case 404: {
                    this.nodeid.cache(file, null);
                }
            }
            throw new DefaultHttpResponseExceptionMappingService().map("Download {0} failed", (Throwable)new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()), file);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }
}

