/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.UserApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerData;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSQuotaFeature
implements Quota {
    private static final Logger log = LogManager.getLogger(SDSQuotaFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSQuotaFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Quota.Space get() throws BackgroundException {
        try {
            Path home = new DefaultHomeFinderService((Session)this.session).find();
            if (!home.isRoot()) {
                if (-1L == home.attributes().getQuota()) {
                    log.warn(String.format("No quota set for node %s", home));
                } else {
                    return new Quota.Space(Long.valueOf(home.attributes().getSize()), Long.valueOf(home.attributes().getQuota() - home.attributes().getSize()));
                }
            }
            CustomerData info = new UserApi((ApiClient)this.session.getClient()).requestCustomerInfo("");
            return new Quota.Space(info.getSpaceUsed(), Long.valueOf(info.getSpaceLimit() - info.getSpaceUsed()));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Failure to read attributes of {0}", e, new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)));
        }
    }
}

