/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.CachingVersionIdProvider;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.VersionIdProvider;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.NodeList;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSNodeIdProvider
extends CachingVersionIdProvider
implements VersionIdProvider {
    private static final Logger log = LogManager.getLogger(SDSNodeIdProvider.class);
    private static final UnicodeNormalizer normalizer = new NFCNormalizer();
    private static final String ROOT_NODE_ID = "0";
    private final SDSSession session;

    public SDSNodeIdProvider(SDSSession session) {
        super(session.getCaseSensitivity());
        this.session = session;
    }

    public String getVersionId(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return version %s from attributes for file %s", file.attributes().getVersionId(), file));
            }
            return file.attributes().getVersionId();
        }
        String cached = super.getVersionId(file, listener);
        if (cached != null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return cached versionid %s for file %s", cached, file));
            }
            return cached;
        }
        return this.getNodeId(file, new HostPreferences(this.session.getHost()).getInteger("sds.listing.chunksize"));
    }

    protected String getNodeId(Path file, int chunksize) throws BackgroundException {
        if (file.isRoot()) {
            return ROOT_NODE_ID;
        }
        try {
            NodeList nodes;
            String type = file.isDirectory() ? "room:folder" : "file";
            int offset = 0;
            do {
                nodes = new NodesApi((ApiClient)this.session.getClient()).searchNodes(URIEncoder.encode((String)normalizer.normalize((CharSequence)file.getName()).toString()), "", -1, null, String.format("type:eq:%s|parentPath:eq:%s/", type, file.getParent().isRoot() ? "" : file.getParent().getAbsolute()), null, offset, chunksize, null);
                for (Node node : nodes.getItems()) {
                    if (!node.getName().equalsIgnoreCase(normalizer.normalize((CharSequence)file.getName()).toString())) continue;
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Return node %s for file %s", node.getId(), file));
                    }
                    return this.cache(file, node.getId().toString());
                }
                offset += chunksize;
            } while (nodes.getItems().size() == chunksize);
            throw new NotfoundException(file.getAbsolute());
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this).map("Failure to read attributes of {0}", e, file);
        }
    }

    public static boolean isEncrypted(Path file) {
        if (file.isRoot()) {
            return false;
        }
        if (file.attributes().getCustom().containsKey("encrypted")) {
            return Boolean.parseBoolean((String)file.attributes().getCustom().get("encrypted"));
        }
        Path parent = file.getParent();
        if (parent.attributes().getCustom().containsKey("encrypted")) {
            return Boolean.parseBoolean((String)parent.attributes().getCustom().get("encrypted"));
        }
        Path container = new DefaultPathContainerService().getContainer(file);
        if (container.attributes().getCustom().containsKey("encrypted")) {
            return Boolean.parseBoolean((String)container.attributes().getCustom().get("encrypted"));
        }
        return false;
    }

    public ByteBuffer getFileKey() throws BackgroundException {
        return this.toBuffer(TripleCryptConverter.toSwaggerFileKey(Crypto.generateFileKey((PlainFileKey.Version)PlainFileKey.Version.AES256GCM)));
    }

    public ByteBuffer toBuffer(FileKey fileKey) throws BackgroundException {
        ObjectWriter writer = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).writerFor(FileKey.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            writer.writeValue((OutputStream)out, (Object)fileKey);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        return ByteBuffer.wrap(out.toByteArray());
    }
}

