/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.MultipartUploadTokenOutputStream;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSUploadService;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSMultipartWriteFeature
implements MultipartWrite<Node> {
    private static final Logger log = LogManager.getLogger(SDSMultipartWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSUploadService upload;

    public SDSMultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
        this.upload = new SDSUploadService(session, nodeid);
    }

    public HttpResponseOutputStream<Node> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        CreateFileUploadResponse uploadResponse = this.upload.start(file, status);
        String uploadUrl = uploadResponse.getUploadUrl();
        if (StringUtils.isBlank((CharSequence)uploadUrl)) {
            throw new InteroperabilityException("Missing upload URL in server response");
        }
        final String uploadToken = uploadResponse.getToken();
        if (StringUtils.isBlank((CharSequence)uploadToken)) {
            throw new InteroperabilityException("Missing upload token in server response");
        }
        MultipartUploadTokenOutputStream proxy = new MultipartUploadTokenOutputStream(this.session, this.nodeid, file, status, uploadUrl);
        return new HttpResponseOutputStream<Node>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("sds.upload.multipart.chunksize"))), (AttributesAdapter)new SDSAttributesAdapter(this.session), status){
            private final AtomicBoolean close;
            private final AtomicReference<Node> node;
            {
                super(proxy, attributes, status2);
                this.close = new AtomicBoolean();
                this.node = new AtomicReference();
            }

            public Node getStatus() {
                return this.node.get();
            }

            public void close() throws IOException {
                try {
                    if (this.close.get()) {
                        log.warn(String.format("Skip double close of stream %s", new Object[]{this}));
                        return;
                    }
                    super.close();
                    this.node.set(SDSMultipartWriteFeature.this.upload.complete(file, uploadToken, status));
                }
                catch (BackgroundException e) {
                    throw new IOException(e);
                }
                finally {
                    this.close.set(true);
                }
            }

            protected void handleIOException(IOException e) throws IOException {
                try {
                    SDSMultipartWriteFeature.this.upload.cancel(file, uploadToken);
                }
                catch (BackgroundException f) {
                    log.warn(String.format("Failure %s cancelling upload for file %s with upload token %s after failure %s", new Object[]{f, file, uploadToken, e}));
                }
                throw e;
            }
        };
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }
}

