/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.CaseInsensitivePathPredicate;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.Version;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSDeleteFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSTouchFeature;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.MoveNode;
import ch.cyberduck.core.sds.io.swagger.client.model.MoveNodesRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.SoftwareVersionData;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateFileRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateFolderRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateRoomRequest;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSMoveFeature
implements Move {
    private static final Logger log = LogManager.getLogger(SDSMoveFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSMoveFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        try {
            long nodeId = Long.parseLong(this.nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener()));
            if (this.containerService.isContainer(file)) {
                Node node = new NodesApi((ApiClient)this.session.getClient()).updateRoom(new UpdateRoomRequest().name(renamed.getName()), nodeId, "", null);
                this.nodeid.cache(renamed, file.attributes().getVersionId());
                this.nodeid.cache(file, null);
                return renamed.withAttributes(new SDSAttributesAdapter(this.session).toAttributes(node));
            }
            if (status.isExists() && !new CaseInsensitivePathPredicate(file).test(renamed)) {
                log.warn(String.format("Delete existing file %s", renamed));
                new SDSDeleteFeature(this.session, this.nodeid).delete(Collections.singletonMap(renamed, status), (PasswordCallback)connectionCallback, callback);
            }
            if (new SimplePathPredicate(file.getParent()).test(renamed.getParent())) {
                if (file.isDirectory()) {
                    new NodesApi((ApiClient)this.session.getClient()).updateFolder(new UpdateFolderRequest().name(renamed.getName()), nodeId, "", null);
                } else {
                    new NodesApi((ApiClient)this.session.getClient()).updateFile(new UpdateFileRequest().name(renamed.getName()), nodeId, "", null);
                }
            } else {
                new NodesApi((ApiClient)this.session.getClient()).moveNodes(new MoveNodesRequest().resolutionStrategy(MoveNodesRequest.ResolutionStrategyEnum.OVERWRITE).addItemsItem(new MoveNode().id(nodeId).name(renamed.getName())).keepShareLinks(new HostPreferences(this.session.getHost()).getBoolean("sds.upload.sharelinks.keep")), Long.parseLong(this.nodeid.getVersionId(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener())), "", null);
            }
            this.nodeid.cache(renamed, file.attributes().getVersionId());
            this.nodeid.cache(file, null);
            return renamed.withAttributes(new PathAttributes(file.attributes()).withVersionId(String.valueOf(nodeId)));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Cannot rename {0}", e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source) && !new SimplePathPredicate(source.getParent()).test(target.getParent())) {
            log.warn(String.format("Deny moving data room %s", source));
            return false;
        }
        if (target.getParent().isRoot() && !source.getParent().isRoot()) {
            log.warn(String.format("Deny moving file %s to root", source));
            return false;
        }
        if (!new SDSTouchFeature(this.session, this.nodeid).validate(target.getName())) {
            log.warn(String.format("Validation failed for target name %s", target));
            return false;
        }
        SDSPermissionsFeature acl = new SDSPermissionsFeature(this.session, this.nodeid);
        if (!new SimplePathPredicate(source.getParent()).test(target.getParent())) {
            if (!acl.containsRole(this.containerService.getContainer(source), SDSPermissionsFeature.CHANGE_ROLE)) {
                log.warn(String.format("Deny move of %s to %s changing parent node with missing role %s on data room %s", source, target, SDSPermissionsFeature.CHANGE_ROLE, this.containerService.getContainer(source)));
                return false;
            }
            if (!acl.containsRole(this.containerService.getContainer(source), SDSPermissionsFeature.DELETE_ROLE)) {
                log.warn(String.format("Deny move of %s to %s changing parent node with missing role %s on data room %s", source, target, SDSPermissionsFeature.DELETE_ROLE, this.containerService.getContainer(source)));
                return false;
            }
            if (!acl.containsRole(this.containerService.getContainer(target), SDSPermissionsFeature.CREATE_ROLE)) {
                log.warn(String.format("Deny move of %s to %s changing parent node with missing role %s on data room %s", source, target, SDSPermissionsFeature.CREATE_ROLE, this.containerService.getContainer(target)));
                return false;
            }
        }
        if (!acl.containsRole(this.containerService.getContainer(source), SDSPermissionsFeature.CHANGE_ROLE)) {
            log.warn(String.format("Deny move of %s to %s with missing permissions for user with missing role %s on data room %s", source, target, SDSPermissionsFeature.CHANGE_ROLE, this.containerService.getContainer(source)));
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getName(), (CharSequence)target.getName()) && new CaseInsensitivePathPredicate(source).test(target)) {
            try {
                SoftwareVersionData version = this.session.softwareVersion();
                Matcher matcher = Pattern.compile("(([0-9]+)\\.([0-9]+)\\.([0-9]+)).*").matcher(version.getRestApiVersion());
                if (matcher.matches() && new Version(matcher.group(1)).compareTo(new Version("4.14")) < 0) {
                    return false;
                }
            }
            catch (BackgroundException e) {
                log.warn(String.format("Ignore failure %s determining version", new Object[]{e}));
            }
        }
        return true;
    }
}

