/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.VersionIdProvider;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.UserAccountWrapper;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UserApi;
import ch.cyberduck.core.sds.io.swagger.client.model.FileFileKeys;
import ch.cyberduck.core.sds.io.swagger.client.model.MissingKeysResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.UserFileKeySetBatchRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserFileKeySetRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserIdFileIdItem;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.UserUserPublicKey;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import ch.cyberduck.core.shared.AbstractSchedulerFeature;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.InvalidKeyPairException;
import com.dracoon.sdk.crypto.error.InvalidPasswordException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSMissingFileKeysSchedulerFeature
extends AbstractSchedulerFeature<List<UserFileKeySetRequest>> {
    private static final Logger log = LogManager.getLogger(SDSMissingFileKeysSchedulerFeature.class);

    public SDSMissingFileKeysSchedulerFeature() {
        this(PreferencesFactory.get().getLong("sds.encryption.missingkeys.scheduler.period"));
    }

    public SDSMissingFileKeysSchedulerFeature(long period) {
        super(period);
    }

    public List<UserFileKeySetRequest> operate(Session<?> client, PasswordCallback callback, Path file) throws BackgroundException {
        SDSSession session = (SDSSession)client;
        SDSNodeIdProvider nodeid = (SDSNodeIdProvider)session._getFeature(VersionIdProvider.class);
        try {
            UserFileKeySetBatchRequest request;
            Long fileId;
            UserAccountWrapper account = session.userAccount();
            if (!account.isEncryptionEnabled()) {
                log.warn(String.format("No key pair found in user account %s", account));
                return Collections.emptyList();
            }
            ArrayList<UserFileKeySetRequest> processed = new ArrayList<UserFileKeySetRequest>();
            UserKeyPairContainer userKeyPairContainer = session.keyPair();
            UserKeyPair keyPair = TripleCryptConverter.toCryptoUserKeyPair(userKeyPairContainer);
            TripleCryptKeyPair triplecrypt = new TripleCryptKeyPair();
            Credentials passphrase = triplecrypt.unlock(callback, session.getHost(), keyPair);
            UserKeyPairContainer userKeyPairContainerDeprecated = session.keyPairDeprecated();
            Credentials passphraseDeprecated = passphrase;
            if (userKeyPairContainerDeprecated != null) {
                passphraseDeprecated = triplecrypt.unlock(callback, session.getHost(), TripleCryptConverter.toCryptoUserKeyPair(userKeyPairContainerDeprecated));
            }
            Long l = fileId = file != null ? Long.valueOf(Long.parseLong(nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener()))) : null;
            do {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Request a list of missing file keys for file %s", file));
                }
                request = new UserFileKeySetBatchRequest();
                MissingKeysResponse missingKeys = new NodesApi((ApiClient)session.getClient()).requestMissingFileKeys(null, null, null, fileId, null, null, null);
                Map<Long, List<UserUserPublicKey>> userPublicKeys = missingKeys.getUsers().stream().collect(Collectors.groupingBy(UserUserPublicKey::getId));
                Map<Long, List<FileFileKeys>> files = missingKeys.getFiles().stream().collect(Collectors.groupingBy(FileFileKeys::getId));
                for (UserIdFileIdItem item : missingKeys.getItems()) {
                    for (FileFileKeys fileKey : files.get(item.getFileId())) {
                        EncryptedFileKey encryptedFileKey = TripleCryptConverter.toCryptoEncryptedFileKey(fileKey.getFileKeyContainer());
                        UserKeyPairContainer keyPairForDecryption = session.getKeyPairForFileKey(encryptedFileKey.getVersion());
                        for (UserUserPublicKey userPublicKey : userPublicKeys.get(item.getUserId())) {
                            EncryptedFileKey fk = this.encryptFileKey(TripleCryptConverter.toCryptoUserPrivateKey(keyPairForDecryption.getPrivateKeyContainer()), encryptedFileKey.getVersion() == EncryptedFileKey.Version.RSA2048_AES256GCM ? passphraseDeprecated : passphrase, userPublicKey, fileKey);
                            UserFileKeySetRequest keySetRequest = new UserFileKeySetRequest().fileId(item.getFileId()).userId(item.getUserId()).fileKey(TripleCryptConverter.toSwaggerFileKey(fk));
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Missing file key processed for file %d and user %d", item.getFileId(), item.getUserId()));
                            }
                            request.addItemsItem(keySetRequest);
                        }
                    }
                }
                if (request.getItems().isEmpty()) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Set file keys with %s", request));
                }
                new NodesApi((ApiClient)session.getClient()).setUserFileKeys(request, "");
                processed.addAll(request.getItems());
            } while (!request.getItems().isEmpty());
            this.deleteDeprecatedKeyPair(session);
            return processed;
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(nodeid).map(e);
        }
        catch (CryptoException e) {
            throw new TripleCryptExceptionMappingService().map(e);
        }
    }

    private void deleteDeprecatedKeyPair(SDSSession session) throws ApiException, BackgroundException {
        MissingKeysResponse missingKeys;
        if (new HostPreferences(session.getHost()).getBoolean("sds.encryption.missingkeys.delete.deprecated") && session.keyPairDeprecated() != null && !session.keyPairDeprecated().equals(session.keyPair()) && (missingKeys = new NodesApi((ApiClient)session.getClient()).requestMissingFileKeys(null, 1, null, null, session.userAccount().getId(), "previous_user_key", null)).getItems().isEmpty()) {
            log.debug("No more deprecated fileKeys to migrate - deleting deprecated key pair");
            new UserApi((ApiClient)session.getClient()).removeUserKeyPair(session.keyPairDeprecated().getPublicKeyContainer().getVersion(), null);
            session.resetUserKeyPairs();
        }
    }

    private EncryptedFileKey encryptFileKey(UserPrivateKey privateKey, Credentials passphrase, UserUserPublicKey pubkey, FileFileKeys fileKeys) throws InvalidFileKeyException, InvalidKeyPairException, InvalidPasswordException, CryptoSystemException, UnknownVersionException {
        PlainFileKey plainFileKey = Crypto.decryptFileKey((EncryptedFileKey)TripleCryptConverter.toCryptoEncryptedFileKey(fileKeys.getFileKeyContainer()), (UserPrivateKey)privateKey, (String)passphrase.getPassword());
        return Crypto.encryptFileKey((PlainFileKey)plainFileKey, (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(pubkey.getPublicKeyContainer()));
    }
}

