/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.NodeList;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSListService
implements ListService {
    private static final Logger log = LogManager.getLogger(SDSListService.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSListService(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return this.list(directory, listener, new HostPreferences(this.session.getHost()).getInteger("sds.listing.chunksize"));
    }

    protected AttributedList<Path> list(Path directory, ListProgressListener listener, int chunksize) throws BackgroundException {
        AttributedList children = new AttributedList();
        try {
            NodeList nodes;
            int offset = 0;
            SDSAttributesAdapter feature = new SDSAttributesAdapter(this.session);
            do {
                nodes = new NodesApi((ApiClient)this.session.getClient()).requestNodes(null, 0, Long.parseLong(this.nodeid.getVersionId(directory, (ListProgressListener)new DisabledListProgressListener())), false, null, "name:asc", offset, chunksize, "");
                for (Node node : nodes.getItems()) {
                    PathAttributes attributes = feature.toAttributes(node);
                    EnumSet<AbstractPath.Type> type = feature.toType(node);
                    Path file = new Path(directory, node.getName(), type, attributes);
                    this.nodeid.cache(file, String.valueOf(node.getId()));
                    children.add((Referenceable)file);
                    listener.chunk(directory, children);
                }
                offset += chunksize;
            } while (nodes.getItems().size() == chunksize);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Listing directory {0} failed", e, directory);
        }
        return children;
    }
}

