/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSMissingFileKeysSchedulerFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSEncryptionBulkFeature
implements Bulk<Void> {
    private static final Logger log = LogManager.getLogger(SDSEncryptionBulkFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSEncryptionBulkFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Void pre(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        switch (type) {
            case download: {
                break;
            }
            default: {
                Map<Path, Boolean> rooms = this.getRoomEncryptionStatus(files);
                for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
                    Path container = new DefaultPathContainerService().getContainer(entry.getKey().remote);
                    if (!rooms.get(container).booleanValue()) continue;
                    TransferStatus status = entry.getValue();
                    status.setFilekey(this.nodeid.getFileKey());
                }
            }
        }
        return null;
    }

    private Map<Path, Boolean> getRoomEncryptionStatus(Map<TransferItem, TransferStatus> files) {
        HashMap<Path, Boolean> rooms = new HashMap<Path, Boolean>();
        DefaultPathContainerService containerService = new DefaultPathContainerService();
        for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
            Path container = containerService.getContainer(entry.getKey().remote);
            if (rooms.containsKey(container)) continue;
            rooms.put(container, SDSNodeIdProvider.isEncrypted(entry.getKey().remote));
        }
        return rooms;
    }

    public void post(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        switch (type) {
            case download: {
                break;
            }
            default: {
                if (!new HostPreferences(this.session.getHost()).getBoolean("sds.encryption.missingkeys.upload") || !this.session.userAccount().isEncryptionEnabled()) break;
                SDSMissingFileKeysSchedulerFeature background = new SDSMissingFileKeysSchedulerFeature();
                Map<Path, Boolean> rooms = this.getRoomEncryptionStatus(files);
                for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
                    Path container;
                    Path file = entry.getKey().remote;
                    if (!file.isFile() || !rooms.get(container = new DefaultPathContainerService().getContainer(file)).booleanValue()) continue;
                    background.operate((Session)this.session, (PasswordCallback)callback, file);
                }
            }
        }
    }

    public Bulk<Void> withDelete(Delete delete) {
        return this;
    }
}

