/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSTouchFeature;
import ch.cyberduck.core.sds.UserAccountWrapper;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFolderRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateRoomRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.EncryptRoomRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSDirectoryFeature
implements Directory<VersionId> {
    private static final Logger log = LogManager.getLogger(SDSDirectoryFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSDirectoryFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                return this.createRoom(folder, new HostPreferences(this.session.getHost()).getBoolean("sds.create.dataroom.encrypt"));
            }
            return this.createFolder(folder);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Cannot create folder {0}", e, folder);
        }
    }

    private Path createFolder(Path folder) throws BackgroundException, ApiException {
        CreateFolderRequest folderRequest = new CreateFolderRequest();
        folderRequest.setParentId(Long.parseLong(this.nodeid.getVersionId(folder.getParent(), (ListProgressListener)new DisabledListProgressListener())));
        folderRequest.setName(folder.getName());
        Node node = new NodesApi((ApiClient)this.session.getClient()).createFolder(folderRequest, "", null);
        this.nodeid.cache(folder, String.valueOf(node.getId()));
        return folder.withAttributes(new SDSAttributesAdapter(this.session).toAttributes(node));
    }

    protected Path createRoom(Path room, boolean encrypt) throws BackgroundException, ApiException {
        CreateRoomRequest roomRequest = new CreateRoomRequest();
        roomRequest.setParentId(null);
        UserAccountWrapper user = this.session.userAccount();
        roomRequest.addAdminIdsItem(user.getId());
        roomRequest.setAdminGroupIds(null);
        if (!room.getParent().isRoot()) {
            roomRequest.setParentId(Long.parseLong(this.nodeid.getVersionId(room.getParent(), (ListProgressListener)new DisabledListProgressListener())));
        }
        roomRequest.setName(room.getName());
        Node node = new NodesApi((ApiClient)this.session.getClient()).createRoom(roomRequest, "", null);
        this.nodeid.cache(room, String.valueOf(node.getId()));
        if (encrypt) {
            EncryptRoomRequest options = new EncryptRoomRequest();
            options.setIsEncrypted(true);
            return room.withType(EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume)).withAttributes(new SDSAttributesAdapter(this.session).toAttributes(new NodesApi((ApiClient)this.session.getClient()).encryptRoom(options, Long.valueOf(this.nodeid.getVersionId(room, (ListProgressListener)new DisabledListProgressListener())), "", null)));
        }
        return room.withType(EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume)).withAttributes(new SDSAttributesAdapter(this.session).toAttributes(node));
    }

    public boolean isSupported(Path workdir, String name) {
        if (workdir.isRoot() && !new HostPreferences(this.session.getHost()).getBoolean("sds.create.dataroom.enable")) {
            log.warn(String.format("Disallow creating new top level data room %s", name));
            return false;
        }
        if (!new SDSTouchFeature(this.session, this.nodeid).validate(name)) {
            log.warn(String.format("Validation failed for target name %s", name));
            return false;
        }
        return new SDSPermissionsFeature(this.session, this.nodeid).containsRole(workdir, SDSPermissionsFeature.CREATE_ROLE);
    }

    public Directory<VersionId> withWriter(Write<VersionId> writer) {
        return this;
    }
}

