/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSDirectS3WriteFeature
extends AbstractHttpWriteFeature<Node> {
    private static final Logger log = LogManager.getLogger(SDSDirectS3WriteFeature.class);
    private final SDSSession session;

    public SDSDirectS3WriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        super((AttributesAdapter)new SDSAttributesAdapter(session));
        this.session = session;
    }

    public HttpResponseOutputStream<Node> write(Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.write(file, status, (DelayedHttpEntityCallable)new DelayedHttpEntityCallable<Node>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Node call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HttpPut request = new HttpPut(status.getUrl());
                    request.setEntity((HttpEntity)entity);
                    request.setHeader("Content-Type", "application/octet-stream");
                    CloseableHttpResponse response = ((SDSApiClient)SDSDirectS3WriteFeature.this.session.getClient()).getClient().execute((HttpUriRequest)request);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 200: {
                                if (!response.containsHeader("ETag")) {
                                    log.error(String.format("Missing ETag in response %s", response));
                                    throw new InteroperabilityException(response.getStatusLine().getReasonPhrase());
                                }
                                if (log.isInfoEnabled()) {
                                    log.info(String.format("Received response %s for part number %d", response, status.getPart()));
                                }
                                status.setChecksum(Checksum.parse((String)StringUtils.remove((String)response.getFirstHeader("ETag").getValue(), (char)'\"')));
                                Node node = null;
                                return node;
                            }
                        }
                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                        throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
                catch (HttpResponseException e) {
                    throw new DefaultHttpResponseExceptionMappingService().map(e);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        });
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }
}

