/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Buffer;
import ch.cyberduck.core.io.BufferOutputStream;
import ch.cyberduck.core.io.FileBuffer;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.local.TemporaryFileService;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSTripleCryptEncryptorFeature;
import ch.cyberduck.core.sds.SDSUploadService;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteS3FileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneratePresignedUrlsRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.PresignedUrl;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadPart;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.SegmentRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.InvalidKeyPairException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class SDSDirectS3UploadFeature
extends HttpUploadFeature<Node, MessageDigest> {
    private static final Logger log = LogManager.getLogger(SDSDirectS3UploadFeature.class);
    public static final int MAXIMUM_UPLOAD_PARTS = 10000;
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Long partsize;
    private final Integer concurrency;
    private final TemporaryFileService temp = TemporaryFileServiceFactory.instance();

    public SDSDirectS3UploadFeature(SDSSession session, SDSNodeIdProvider nodeid, Write<Node> writer) {
        this(session, nodeid, writer, new HostPreferences(session.getHost()).getLong("s3.upload.multipart.size"), new HostPreferences(session.getHost()).getInteger("s3.upload.multipart.concurrency"));
    }

    public SDSDirectS3UploadFeature(SDSSession session, SDSNodeIdProvider nodeid, Write<Node> writer, Long partsize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.nodeid = nodeid;
        this.partsize = partsize;
        this.concurrency = concurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)this.concurrency);
        try {
            CreateFileUploadRequest createFileUploadRequest = new CreateFileUploadRequest().directS3Upload(true).timestampModification(status.getTimestamp() != null ? new DateTime((Object)status.getTimestamp()) : null).size(-1L == status.getLength() ? null : Long.valueOf(status.getLength())).parentId(Long.parseLong(this.nodeid.getVersionId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))).name(file.getName());
            CreateFileUploadResponse createFileUploadResponse = new NodesApi((ApiClient)this.session.getClient()).createFileUploadChannel(createFileUploadRequest, "");
            if (log.isDebugEnabled()) {
                log.debug(String.format("upload started for %s with response %s", file, createFileUploadResponse));
            }
            HashMap<Integer, TransferStatus> etags = new HashMap<Integer, TransferStatus>();
            List<PresignedUrl> presignedUrls = this.retrievePresignedUrls(createFileUploadResponse, status);
            ArrayList<Future<TransferStatus>> parts = new ArrayList<Future<TransferStatus>>();
            String random = new UUIDRandomStringService().random();
            try (InputStream in = SDSNodeIdProvider.isEncrypted(file) ? new SDSTripleCryptEncryptorFeature(this.session, this.nodeid).encrypt(file, local.getInputStream(), status) : local.getInputStream();){
                long size = status.getLength() + status.getOffset();
                long offset = 0L;
                long remaining = status.getLength();
                int partNumber = 1;
                while (remaining >= 0L) {
                    long length = Math.min(Math.max(size / 9999L, this.partsize), remaining);
                    PresignedUrl presignedUrl = presignedUrls.get(partNumber - 1);
                    if (SDSNodeIdProvider.isEncrypted(file)) {
                        Local temporary = this.temp.create(String.format("%s-%d", random, partNumber));
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Encrypted contents for part %d to %s", partNumber, temporary));
                        }
                        FileBuffer buffer = new FileBuffer(temporary);
                        new StreamCopier((StreamCancelation)status, StreamProgress.noop).withAutoclose(false).withLimit(Long.valueOf(length)).transfer(in, (OutputStream)new BufferOutputStream((Buffer)buffer));
                        parts.add(this.submit(pool, file, temporary, (Buffer)buffer, throttle, listener, status, presignedUrl.getUrl(), presignedUrl.getPartNumber(), 0L, length, callback));
                    } else {
                        parts.add(this.submit(pool, file, local, Buffer.noop, throttle, listener, status, presignedUrl.getUrl(), presignedUrl.getPartNumber(), offset, length, callback));
                    }
                    offset += length;
                    if (0L == (remaining -= length)) {
                        break;
                    }
                    ++partNumber;
                }
            }
            for (Future node : parts) {
                try {
                    TransferStatus part = (TransferStatus)Uninterruptibles.getUninterruptibly((Future)node);
                    etags.put(part.getPart(), part);
                }
                catch (ExecutionException e) {
                    log.warn(String.format("Part upload failed with execution failure %s", e.getMessage()));
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
            }
            CompleteS3FileUploadRequest completeS3FileUploadRequest = new CompleteS3FileUploadRequest().keepShareLinks(new HostPreferences(this.session.getHost()).getBoolean("sds.upload.sharelinks.keep")).resolutionStrategy(CompleteS3FileUploadRequest.ResolutionStrategyEnum.OVERWRITE);
            if (status.getFilekey() != null) {
                ObjectReader objectReader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                FileKey fileKey = (FileKey)objectReader.readValue(status.getFilekey().array());
                EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(this.session.keyPair().getPublicKeyContainer()));
                completeS3FileUploadRequest.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
            }
            etags.forEach((key, value) -> completeS3FileUploadRequest.addPartsItem(new S3FileUploadPart().partEtag(value.getChecksum().hash).partNumber((Integer)key)));
            if (log.isDebugEnabled()) {
                log.debug(String.format("Complete file upload with %s for %s", completeS3FileUploadRequest, file));
            }
            new NodesApi((ApiClient)this.session.getClient()).completeS3FileUpload(completeS3FileUploadRequest, createFileUploadResponse.getUploadId(), "");
            new SDSUploadService(this.session, this.nodeid).await(file, status, createFileUploadResponse.getUploadId());
            Node node = null;
            return node;
        }
        catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException | UnknownVersionException e) {
            throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.temp.shutdown();
            pool.shutdown(false);
        }
    }

    private List<PresignedUrl> retrievePresignedUrls(CreateFileUploadResponse createFileUploadResponse, TransferStatus status) throws ApiException {
        long size = status.getLength() + status.getOffset();
        ArrayList<PresignedUrl> presignedUrls = new ArrayList<PresignedUrl>();
        GeneratePresignedUrlsRequest presignedUrlsRequest = new GeneratePresignedUrlsRequest().firstPartNumber(1);
        long remaining = status.getLength();
        int partNumber = 1;
        while (remaining >= 0L) {
            long length = Math.min(Math.max(size / 9999L, this.partsize), remaining);
            if (partNumber > 1 && length < Math.max(size / 9999L, this.partsize)) {
                presignedUrls.addAll(new NodesApi((ApiClient)this.session.getClient()).generatePresignedUrlsFiles(new GeneratePresignedUrlsRequest().firstPartNumber(partNumber).lastPartNumber(partNumber).size(length), createFileUploadResponse.getUploadId(), "").getUrls());
            } else {
                presignedUrlsRequest.lastPartNumber(partNumber).size(length);
            }
            if (0L == (remaining -= length)) break;
            ++partNumber;
        }
        presignedUrls.addAll(0, new NodesApi((ApiClient)this.session.getClient()).generatePresignedUrlsFiles(presignedUrlsRequest, createFileUploadResponse.getUploadId(), "").getUrls());
        return presignedUrls;
    }

    private Future<TransferStatus> submit(ThreadPool pool, final Path file, final Local local, final Buffer buffer, final BandwidthThrottle throttle, StreamListener listener, final TransferStatus overall, final String url, final Integer partNumber, final long offset, final long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        final BytecountStreamListener counter = new BytecountStreamListener(listener);
        return pool.execute((Callable)new SegmentRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<TransferStatus>(){

            public TransferStatus call() throws BackgroundException {
                overall.validate();
                TransferStatus status = new TransferStatus().segment(true).withLength(length).withOffset(offset);
                status.setUrl(url);
                status.setPart(partNumber);
                status.setHeader(overall.getHeader());
                status.setFilekey(overall.getFilekey());
                SDSDirectS3UploadFeature.super.upload(file, local, throttle, (StreamListener)counter, status, (StreamCancelation)overall, (StreamProgress)status, callback);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Received response for part number %d", partNumber));
                }
                buffer.close();
                return status;
            }
        }, (StreamCancelation)overall, counter));
    }
}

