/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSUploadService;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteS3FileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.GeneratePresignedUrlsRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.io.swagger.client.model.PresignedUrl;
import ch.cyberduck.core.sds.io.swagger.client.model.PresignedUrlList;
import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadPart;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.error.InvalidFileKeyException;
import com.dracoon.sdk.crypto.error.InvalidKeyPairException;
import com.dracoon.sdk.crypto.error.UnknownVersionException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class SDSDirectS3MultipartWriteFeature
extends AbstractHttpWriteFeature<Node>
implements MultipartWrite<Node> {
    private static final Logger log = LogManager.getLogger(SDSDirectS3MultipartWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Integer partsize;

    public SDSDirectS3MultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this(session, nodeid, new HostPreferences(session.getHost()).getInteger("sds.upload.multipart.chunksize"));
    }

    public SDSDirectS3MultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Integer partsize) {
        super((AttributesAdapter)new SDSAttributesAdapter(session));
        this.session = session;
        this.nodeid = nodeid;
        this.partsize = partsize;
    }

    public HttpResponseOutputStream<Node> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            CreateFileUploadRequest createFileUploadRequest = new CreateFileUploadRequest().directS3Upload(true).timestampModification(status.getTimestamp() != null ? new DateTime((Object)status.getTimestamp()) : null).parentId(Long.parseLong(this.nodeid.getVersionId(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))).name(file.getName());
            CreateFileUploadResponse createFileUploadResponse = new NodesApi((ApiClient)this.session.getClient()).createFileUploadChannel(createFileUploadRequest, "");
            if (log.isDebugEnabled()) {
                log.debug(String.format("upload started for %s with response %s", file, createFileUploadResponse));
            }
            final MultipartOutputStream proxy = new MultipartOutputStream(createFileUploadResponse, file, status);
            return new HttpResponseOutputStream<Node>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, this.partsize), (AttributesAdapter)new SDSAttributesAdapter(this.session), status){

                public Node getStatus() {
                    return proxy.getResult();
                }
            };
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Upload {0} failed", e, file);
        }
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean timestamp() {
        return true;
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final Map<Integer, Checksum> completed = new HashMap<Integer, Checksum>();
        private final CreateFileUploadResponse createFileUploadResponse;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<BackgroundException> canceled = new AtomicReference();
        private final AtomicReference<Node> result = new AtomicReference();
        private int partNumber;

        public MultipartOutputStream(CreateFileUploadResponse createFileUploadResponse, Path file, TransferStatus status) {
            this.createFileUploadResponse = createFileUploadResponse;
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] b, final int off, final int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                ++this.partNumber;
                this.completed.put(this.partNumber, (Checksum)new DefaultRetryCallable(SDSDirectS3MultipartWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Checksum>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public Checksum call() throws BackgroundException {
                        try {
                            PresignedUrlList presignedUrlList = new NodesApi((ApiClient)SDSDirectS3MultipartWriteFeature.this.session.getClient()).generatePresignedUrlsFiles(new GeneratePresignedUrlsRequest().firstPartNumber(MultipartOutputStream.this.partNumber).lastPartNumber(MultipartOutputStream.this.partNumber).size(Long.valueOf(len)), MultipartOutputStream.this.createFileUploadResponse.getUploadId(), "");
                            Iterator<PresignedUrl> iterator = presignedUrlList.getUrls().iterator();
                            if (!iterator.hasNext()) throw new InteroperabilityException().withFile(MultipartOutputStream.this.file);
                            PresignedUrl url = iterator.next();
                            HttpPut request = new HttpPut(url.getUrl());
                            request.setEntity((HttpEntity)new ByteArrayEntity(b, off, len));
                            request.setHeader("Content-Type", "application/octet-stream");
                            CloseableHttpResponse response = ((SDSApiClient)SDSDirectS3MultipartWriteFeature.this.session.getClient()).getClient().execute((HttpUriRequest)request);
                            try {
                                switch (response.getStatusLine().getStatusCode()) {
                                    case 200: {
                                        if (!response.containsHeader("ETag")) {
                                            log.error(String.format("Missing ETag in response %s", response));
                                            throw new InteroperabilityException(response.getStatusLine().getReasonPhrase());
                                        }
                                        if (log.isInfoEnabled()) {
                                            log.info(String.format("Received response %s for part number %d", response, MultipartOutputStream.this.partNumber));
                                        }
                                        Checksum checksum = Checksum.parse((String)StringUtils.remove((String)response.getFirstHeader("ETag").getValue(), (char)'\"'));
                                        return checksum;
                                    }
                                }
                                EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                                throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                            }
                            finally {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                        }
                        catch (HttpResponseException e) {
                            throw new DefaultHttpResponseExceptionMappingService().map("Upload {0} failed", (Throwable)e, MultipartOutputStream.this.file);
                        }
                        catch (IOException e) {
                            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, MultipartOutputStream.this.file);
                        }
                        catch (ApiException e) {
                            throw new SDSExceptionMappingService(SDSDirectS3MultipartWriteFeature.this.nodeid).map("Upload {0} failed", e, MultipartOutputStream.this.file);
                        }
                    }
                }, (StreamCancelation)this.overall).call());
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn(String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    return;
                }
                if (this.completed.isEmpty()) {
                    this.write(new byte[0]);
                }
                CompleteS3FileUploadRequest completeS3FileUploadRequest = new CompleteS3FileUploadRequest().keepShareLinks(new HostPreferences(SDSDirectS3MultipartWriteFeature.this.session.getHost()).getBoolean("sds.upload.sharelinks.keep")).resolutionStrategy(CompleteS3FileUploadRequest.ResolutionStrategyEnum.OVERWRITE);
                if (this.overall.getFilekey() != null) {
                    ObjectReader reader = ((SDSApiClient)SDSDirectS3MultipartWriteFeature.this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                    FileKey fileKey = (FileKey)reader.readValue(this.overall.getFilekey().array());
                    EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(SDSDirectS3MultipartWriteFeature.this.session.keyPair().getPublicKeyContainer()));
                    completeS3FileUploadRequest.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
                }
                this.completed.forEach((key, value) -> completeS3FileUploadRequest.addPartsItem(new S3FileUploadPart().partEtag(value.hash).partNumber((Integer)key)));
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Complete file upload with %s for %s", completeS3FileUploadRequest, this.file));
                }
                new NodesApi((ApiClient)SDSDirectS3MultipartWriteFeature.this.session.getClient()).completeS3FileUpload(completeS3FileUploadRequest, this.createFileUploadResponse.getUploadId(), "");
                this.result.set(new SDSUploadService(SDSDirectS3MultipartWriteFeature.this.session, SDSDirectS3MultipartWriteFeature.this.nodeid).await(this.file, this.overall, this.createFileUploadResponse.getUploadId()).getNode());
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            catch (ApiException e) {
                throw new IOException(new SDSExceptionMappingService(SDSDirectS3MultipartWriteFeature.this.nodeid).map("Upload {0} failed", e, this.file));
            }
            catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException | UnknownVersionException e) {
                throw new IOException(new TripleCryptExceptionMappingService().map("Upload {0} failed", e, this.file));
            }
            finally {
                this.close.set(true);
            }
        }

        public Node getResult() {
            return this.result.get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("multipart=").append(this.createFileUploadResponse);
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }
    }
}

