/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSDelegatingWriteFeature
implements MultipartWrite<Node> {
    private static final Logger log = LogManager.getLogger(SDSDelegatingWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Write<Node> proxy;

    public SDSDelegatingWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Write<Node> proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public StatusOutputStream<Node> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (SDSNodeIdProvider.isEncrypted(file)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return encrypting writer for %s", file));
            }
            return new TripleCryptWriteFeature(this.session, this.nodeid, this.proxy).write(file, status, callback);
        }
        return this.proxy.write(file, status, callback);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        if (SDSNodeIdProvider.isEncrypted(file)) {
            return new TripleCryptWriteFeature(this.session, this.nodeid, this.proxy).append(file, status);
        }
        return this.proxy.append(file, status);
    }

    public boolean random() {
        return this.proxy.random();
    }

    public boolean timestamp() {
        return this.proxy.timestamp();
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        if (SDSNodeIdProvider.isEncrypted(file)) {
            return new TripleCryptWriteFeature(this.session, this.nodeid, this.proxy).checksum(file, status);
        }
        return this.proxy.checksum(file, status);
    }
}

