/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.sds.SDSCopyFeature;
import ch.cyberduck.core.sds.SDSDelegatingCopyFeature;
import ch.cyberduck.core.sds.SDSDeleteFeature;
import ch.cyberduck.core.sds.SDSMoveFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSDelegatingMoveFeature
implements Move {
    private static final Logger log = LogManager.getLogger(SDSDelegatingMoveFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSMoveFeature proxy;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSDelegatingMoveFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSMoveFeature proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public Path move(Path source, Path target, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        if (this.containerService.isContainer(source) && new SimplePathPredicate(source.getParent()).test(target.getParent())) {
            return this.proxy.move(source, target, status, callback, connectionCallback);
        }
        if (SDSNodeIdProvider.isEncrypted(source) ^ SDSNodeIdProvider.isEncrypted(target)) {
            SDSDelegatingCopyFeature copy = new SDSDelegatingCopyFeature(this.session, this.nodeid, new SDSCopyFeature(this.session, this.nodeid));
            if (log.isDebugEnabled()) {
                log.debug(String.format("Move %s to %s using copy feature %s", source, target, copy));
            }
            Path c = copy.copy(source, target, status, connectionCallback, (StreamListener)new DisabledStreamListener());
            SDSDeleteFeature delete = new SDSDeleteFeature(this.session, this.nodeid);
            if (delete.isSupported(source)) {
                log.warn(String.format("Delete source %s copied to %s", source, target));
                delete.delete(Collections.singletonMap(source, status), (PasswordCallback)connectionCallback, callback);
            }
            return c;
        }
        return this.proxy.move(source, target, status, callback, connectionCallback);
    }

    public boolean isRecursive(Path source, Path target) {
        if (SDSNodeIdProvider.isEncrypted(source) ^ SDSNodeIdProvider.isEncrypted(target)) {
            return ((Copy)this.session.getFeature(Copy.class)).isRecursive(source, target);
        }
        return this.proxy.isRecursive(source, target);
    }

    public boolean isSupported(Path source, Path target) {
        if (SDSNodeIdProvider.isEncrypted(source) ^ SDSNodeIdProvider.isEncrypted(target)) {
            return ((Copy)this.session.getFeature(Copy.class)).isSupported(source, target);
        }
        return this.proxy.isSupported(source, target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SDSDelegatingMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

