/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSCopyFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.shared.DefaultCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;

public class SDSDelegatingCopyFeature
implements Copy {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSCopyFeature proxy;
    private final DefaultCopyFeature copy;

    public SDSDelegatingCopyFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSCopyFeature proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
        this.copy = new DefaultCopyFeature((Session)session);
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        if (this.proxy.isSupported(source, target)) {
            return this.proxy.copy(source, target, status, callback, listener);
        }
        if (SDSNodeIdProvider.isEncrypted(target)) {
            status.setFilekey(this.nodeid.getFileKey());
        }
        Path result = this.copy.copy(source, target, status, callback, listener);
        this.nodeid.cache(target, null);
        return result.withAttributes(new SDSAttributesFinderFeature(this.session, this.nodeid).find(result));
    }

    public boolean isRecursive(Path source, Path target) {
        if (this.proxy.isSupported(source, target)) {
            return this.proxy.isRecursive(source, target);
        }
        return this.copy.isRecursive(source, target);
    }

    public boolean isSupported(Path source, Path target) {
        if (this.proxy.isSupported(source, target)) {
            return true;
        }
        return this.copy.isSupported(source, target);
    }
}

