/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CopyNode;
import ch.cyberduck.core.sds.io.swagger.client.model.CopyNodesRequest;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSCopyFeature
implements Copy {
    private static final Logger log = LogManager.getLogger(SDSCopyFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSCopyFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            new NodesApi((ApiClient)this.session.getClient()).copyNodes(new CopyNodesRequest().resolutionStrategy(CopyNodesRequest.ResolutionStrategyEnum.OVERWRITE).addItemsItem(new CopyNode().id(Long.parseLong(this.nodeid.getVersionId(source, (ListProgressListener)new DisabledListProgressListener())))).keepShareLinks(new HostPreferences(this.session.getHost()).getBoolean("sds.upload.sharelinks.keep")), Long.parseLong(this.nodeid.getVersionId(target.getParent(), (ListProgressListener)new DisabledListProgressListener())), "", null);
            listener.sent(status.getLength());
            this.nodeid.cache(target, null);
            PathAttributes attributes = new SDSAttributesFinderFeature(this.session, this.nodeid).find(target);
            this.nodeid.cache(target, attributes.getVersionId());
            return target.withAttributes(attributes);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source)) {
            return false;
        }
        if (SDSNodeIdProvider.isEncrypted(source) ^ SDSNodeIdProvider.isEncrypted(target)) {
            log.warn(String.format("Cannot use server side copy with source container %s and target container %s", this.containerService.getContainer(source), this.containerService.getContainer(target)));
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getName(), (CharSequence)target.getName())) {
            log.warn(String.format("Deny copy of %s for changed name %s", source, target.getName()));
            return false;
        }
        if (Objects.equals(source.getParent(), target.getParent())) {
            log.warn(String.format("Deny copy of %s to %s", source, target));
            return false;
        }
        return true;
    }
}

