/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.sds.SDSDeleteFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.DeleteDeletedNodesRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.DeleteNodesRequest;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SDSBatchDeleteFeature
implements Delete {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSBatchDeleteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        HashMap regular = new HashMap();
        HashMap trashed = new HashMap();
        for (Path file : files.keySet()) {
            HashMap set;
            HashMap<Object, ArrayList<Object>> hashMap = set = file.attributes().isDuplicate() ? trashed : regular;
            if (set.containsKey(file.getParent())) {
                ((List)set.get(file.getParent())).add(Long.parseLong(this.nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener())));
            } else {
                ArrayList<Long> nodes = new ArrayList<Long>();
                nodes.add(Long.parseLong(this.nodeid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener())));
                set.put(file.getParent(), nodes);
            }
            callback.delete(file);
            this.nodeid.cache(file, null);
        }
        for (List nodes : regular.values()) {
            try {
                new NodesApi((ApiClient)this.session.getClient()).removeNodes(new DeleteNodesRequest().nodeIds(nodes), "");
            }
            catch (ApiException e) {
                throw new SDSExceptionMappingService(this.nodeid).map("Cannot delete {0}", e, files.keySet().iterator().next());
            }
        }
        for (List nodes : trashed.values()) {
            try {
                new NodesApi((ApiClient)this.session.getClient()).removeDeletedNodes(new DeleteDeletedNodesRequest().deletedNodeIds(nodes), "");
            }
            catch (ApiException e) {
                throw new SDSExceptionMappingService(this.nodeid).map("Cannot delete {0}", e, files.keySet().iterator().next());
            }
        }
    }

    public boolean isSupported(Path file) {
        return new SDSDeleteFeature(this.session, this.nodeid).isSupported(file);
    }

    public boolean isRecursive() {
        return true;
    }
}

