/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.sds.SDSAttributesAdapter;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.DeletedNode;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = LogManager.getLogger(SDSAttributesFinderFeature.class);
    public static final String KEY_CNT_DOWNLOADSHARES = "count_downloadshares";
    public static final String KEY_CNT_UPLOADSHARES = "count_uploadshares";
    public static final String KEY_ENCRYPTED = "encrypted";
    public static final String KEY_CLASSIFICATION = "classification";
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSAttributesAdapter adapter;

    public SDSAttributesFinderFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
        this.adapter = new SDSAttributesAdapter(session);
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            PathAttributes attributes = new PathAttributes();
            if (this.session.userAccount().isUserInRole(SDSPermissionsFeature.ROOM_MANAGER_ROLE)) {
                Acl acl = new Acl(new Acl.UserAndRole[0]);
                acl.addAll((Acl.User)new Acl.CanonicalUser(), new Acl.Role[]{SDSPermissionsFeature.CREATE_ROLE});
                attributes.setAcl(acl);
            }
            return attributes;
        }
        String id = this.nodeid.getVersionId(file, listener);
        try {
            return this.findNode(file, id);
        }
        catch (NotfoundException e) {
            return this.findNode(file, this.nodeid.getVersionId(file, listener));
        }
    }

    private PathAttributes findNode(Path file, String nodeId) throws BackgroundException {
        try {
            if (file.attributes().isDuplicate()) {
                DeletedNode node = new NodesApi((ApiClient)this.session.getClient()).requestDeletedNode(Long.parseLong(nodeId), "", null);
                return this.adapter.toAttributes(node);
            }
            Node node = new NodesApi((ApiClient)this.session.getClient()).requestNode(Long.parseLong(nodeId), "", null);
            return this.adapter.toAttributes(node);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService(this.nodeid).map("Failure to read attributes of {0}", e, file);
        }
    }
}

