/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.DeletedNode;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SDSAttributesAdapter
implements AttributesAdapter<Node> {
    private static final Logger log = LogManager.getLogger(SDSAttributesFinderFeature.class);
    private final SDSSession session;

    public SDSAttributesAdapter(SDSSession session) {
        this.session = session;
    }

    public PathAttributes toAttributes(Node node) {
        PathAttributes attributes = new PathAttributes();
        attributes.setVersionId(String.valueOf(node.getId()));
        attributes.setRevision(node.getBranchVersion());
        if (!node.isIsEncrypted().booleanValue()) {
            attributes.setChecksum(Checksum.parse((String)node.getHash()));
        }
        attributes.setModificationDate(node.getUpdatedAt() != null ? node.getUpdatedAt().getMillis() : -1L);
        if (node.getTimestampModification() != null) {
            attributes.setModificationDate(node.getTimestampModification().getMillis());
        }
        attributes.setCreationDate(node.getCreatedAt() != null ? node.getCreatedAt().getMillis() : -1L);
        if (node.getTimestampCreation() != null) {
            attributes.setCreationDate(node.getTimestampCreation().getMillis());
        }
        if (null != node.getSize()) {
            attributes.setSize(node.getSize().longValue());
        }
        if (null != node.getQuota()) {
            attributes.setQuota(node.getQuota().longValue());
        }
        attributes.setPermission(this.toPermission(node));
        attributes.setOwner(node.getUpdatedBy().getDisplayName());
        attributes.setAcl(this.toAcl(node));
        HashMap<String, String> custom = new HashMap<String, String>();
        if (null != node.getCntDownloadShares()) {
            custom.put("count_downloadshares", String.valueOf(node.getCntDownloadShares()));
        }
        if (null != node.getCntUploadShares()) {
            custom.put("count_uploadshares", String.valueOf(node.getCntUploadShares()));
        }
        if (null != node.isIsEncrypted()) {
            custom.put("encrypted", String.valueOf(node.isIsEncrypted()));
        }
        if (null != node.getClassification()) {
            custom.put("classification", String.valueOf(node.getClassification().getValue()));
        }
        attributes.setCustom(custom);
        return attributes;
    }

    public PathAttributes toAttributes(DeletedNode node) {
        PathAttributes attributes = new PathAttributes();
        attributes.setDuplicate(true);
        attributes.setVersionId(String.valueOf(node.getId()));
        attributes.setCreationDate(node.getCreatedAt() != null ? node.getCreatedAt().getMillis() : -1L);
        attributes.setModificationDate(node.getUpdatedAt() != null ? node.getUpdatedAt().getMillis() : -1L);
        attributes.setSize(node.getSize().longValue());
        attributes.setOwner(node.getDeletedBy().getDisplayName());
        attributes.setPermission(new Permission(Permission.Action.none, Permission.Action.none, Permission.Action.none));
        return attributes;
    }

    public EnumSet<AbstractPath.Type> toType(Node node) {
        EnumSet<AbstractPath.Type> type;
        switch (node.getType()) {
            case ROOM: {
                type = EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume);
                break;
            }
            case FOLDER: {
                type = EnumSet.of(AbstractPath.Type.directory);
                break;
            }
            default: {
                type = EnumSet.of(AbstractPath.Type.file);
            }
        }
        return type;
    }

    protected Permission toPermission(Node node) {
        Permission permission;
        block10: {
            permission = new Permission(Permission.Action.none, Permission.Action.none, Permission.Action.none);
            if (node.isIsEncrypted().booleanValue() && node.getType() == Node.TypeEnum.FILE) {
                try {
                    if (null != this.session.keyPair()) {
                        permission.setUser(permission.getUser().or(Permission.Action.read));
                        break block10;
                    }
                    log.warn(String.format("Missing read permission for node %s with missing key pair", node));
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Ignore failure %s retrieving key pair", new Object[]{e}));
                }
            } else {
                permission.setUser(permission.getUser().or(Permission.Action.read));
            }
        }
        switch (node.getType()) {
            case ROOM: 
            case FOLDER: {
                permission.setUser(permission.getUser().or(Permission.Action.execute));
            }
        }
        if (node.getPermissions().isChange().booleanValue() && node.getPermissions().isDelete().booleanValue()) {
            permission.setUser(permission.getUser().or(Permission.Action.write));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Map node permissions %s to %s", node.getPermissions(), permission));
        }
        return permission;
    }

    protected Acl toAcl(Node node) {
        Acl acl = new Acl(new Acl.UserAndRole[0]);
        Acl.CanonicalUser user = new Acl.CanonicalUser();
        if (node.getPermissions().isManage().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.MANAGE_ROLE});
        }
        if (node.getPermissions().isRead().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.READ_ROLE});
        }
        if (node.getPermissions().isCreate().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CREATE_ROLE});
        }
        if (node.getPermissions().isChange().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CHANGE_ROLE});
        }
        if (node.getPermissions().isDelete().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DELETE_ROLE});
        }
        if (node.getPermissions().isManageDownloadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DOWNLOAD_SHARE_ROLE});
        }
        if (node.getPermissions().isManageUploadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.UPLOAD_SHARE_ROLE});
        }
        return acl;
    }
}

