/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.sshj;

import com.hierynomus.sshj.key.KeyAlgorithm;
import com.hierynomus.sshj.key.KeyAlgorithms;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Identity;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;

public class AuthAgent
extends AbstractAuthMethod {
    private final AgentProxy agentProxy;
    private final Identity identity;
    private final String algorithm;
    private final String comment;
    private Queue<KeyAlgorithm> available;
    private final KeyType keyType;

    public AuthAgent(AgentProxy agentProxy, Identity identity) throws Buffer.BufferException {
        super("publickey");
        this.agentProxy = agentProxy;
        this.identity = identity;
        this.comment = new String(identity.getComment());
        this.algorithm = new Buffer.PlainBuffer(identity.getBlob()).readString();
        this.keyType = KeyType.fromString((String)this.algorithm);
    }

    private KeyAlgorithm getPublicKeyAlgorithm(KeyType keyType) throws TransportException {
        if (this.available == null) {
            this.available = new LinkedList<KeyAlgorithm>(this.params.getTransport().getClientKeyAlgorithms(keyType));
        }
        return this.available.peek();
    }

    public boolean shouldRetry() {
        if (this.available != null) {
            this.available.poll();
            return !this.available.isEmpty();
        }
        return false;
    }

    protected SSHPacket putPubKey(SSHPacket reqBuf) throws UserAuthException {
        try {
            KeyAlgorithm ka = this.getPublicKeyAlgorithm(this.keyType);
            if (ka != null) {
                ((SSHPacket)((SSHPacket)reqBuf.putString(ka.getKeyAlgorithm())).putBytes(this.identity.getBlob())).getCompactData();
                return reqBuf;
            }
        }
        catch (IOException ioe) {
            throw new UserAuthException("No KeyAlgorithm configured for key " + this.keyType, (Throwable)ioe);
        }
        throw new UserAuthException("No KeyAlgorithm configured for key " + this.keyType);
    }

    private int getSignFlags(KeyAlgorithm algorithm) {
        if (this.keyType == KeyType.RSA) {
            if (KeyAlgorithms.RSASHA256().getName().equals(algorithm.getKeyAlgorithm())) {
                return 2;
            }
            if (KeyAlgorithms.RSASHA512().getName().equals(algorithm.getKeyAlgorithm())) {
                return 4;
            }
        }
        return 0;
    }

    protected SSHPacket putSig(SSHPacket reqBuf) throws TransportException {
        byte[] dataToSign = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putBuffer((Buffer)reqBuf)).getCompactData();
        reqBuf.putBytes(this.agentProxy.sign(this.identity.getBlob(), dataToSign, this.getSignFlags(this.getPublicKeyAlgorithm(this.keyType))));
        return reqBuf;
    }

    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.sendSignedReq();
        } else {
            super.handle(cmd, buf);
        }
    }

    private SSHPacket buildReq(boolean signed) throws UserAuthException {
        this.log.debug("Attempting authentication using agent identity {}", (Object)this.comment);
        return this.putPubKey((SSHPacket)super.buildReq().putBoolean(signed));
    }

    private void sendSignedReq() throws UserAuthException, TransportException {
        this.log.debug("Key acceptable, sending signed request");
        this.params.getTransport().write(this.putSig(this.buildReq(true)));
    }

    protected SSHPacket buildReq() throws UserAuthException {
        return this.buildReq(false);
    }
}

