/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa;

import com.sun.jna.Native;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rococoa.ID;
import org.rococoa.RococoaException;
import org.rococoa.Selector;
import org.rococoa.StringEncoding;
import org.rococoa.cocoa.CFIndex;
import org.rococoa.internal.FoundationLibrary;
import org.rococoa.internal.MainThreadUtils;
import org.rococoa.internal.MsgSendInvocationMapper;
import org.rococoa.internal.MsgSendLibrary;
import org.rococoa.internal.OCInvocationCallbacks;
import org.rococoa.internal.RococoaLibrary;
import org.rococoa.internal.VarArgsUnpacker;

public abstract class Foundation {
    private static final Logger logging = Logger.getLogger("org.rococoa.foundation");
    private static final FoundationLibrary foundationLibrary;
    private static final MsgSendLibrary messageSendLibrary;
    private static final RococoaLibrary rococoaLibrary;
    private static final Map<String, Selector> selectorCache;

    private Foundation() {
    }

    public static void nsLog(String format, Object thing) {
        ID formatAsCFString = Foundation.cfString(format);
        try {
            foundationLibrary.NSLog(formatAsCFString, thing);
        }
        finally {
            Foundation.cfRelease(formatAsCFString);
        }
    }

    public static ID cfString(String s) {
        byte[] utf16Bytes = s.getBytes(StandardCharsets.UTF_16LE);
        return foundationLibrary.CFStringCreateWithBytes(null, utf16Bytes, utf16Bytes.length, StringEncoding.kCFStringEncodingUTF16LE.value, (byte)0);
    }

    public static ID cfRetain(ID id) {
        if (logging.isLoggable(Level.FINEST)) {
            logging.finest(String.format("calling cfRetain(%s)", new Object[]{id}));
        }
        return foundationLibrary.CFRetain(id);
    }

    public static void cfRelease(ID id) {
        if (logging.isLoggable(Level.FINEST)) {
            logging.finest(String.format("calling cfRelease(%s)", new Object[]{id}));
        }
        foundationLibrary.CFRelease(id);
    }

    public static CFIndex cfGetRetainCount(ID cfTypeRef) {
        return foundationLibrary.CFGetRetainCount(cfTypeRef);
    }

    public static String toString(ID cfString) {
        return Foundation.toStringViaUTF8(cfString);
    }

    static String toStringViaUTF16(ID cfString) {
        int lengthInChars = foundationLibrary.CFStringGetLength(cfString);
        int potentialLengthInBytes = 3 * lengthInChars + 1;
        byte[] buffer = new byte[potentialLengthInBytes];
        byte ok = foundationLibrary.CFStringGetCString(cfString, buffer, buffer.length, StringEncoding.kCFStringEncodingUTF16LE.value);
        if (ok == 0) {
            throw new RococoaException("Could not convert string");
        }
        return new String(buffer, StandardCharsets.UTF_16LE).substring(0, lengthInChars);
    }

    static String toStringViaUTF8(ID cfString) {
        int lengthInChars = foundationLibrary.CFStringGetLength(cfString);
        int potentialLengthInBytes = 3 * lengthInChars + 1;
        byte[] buffer = new byte[potentialLengthInBytes];
        byte ok = foundationLibrary.CFStringGetCString(cfString, buffer, buffer.length, StringEncoding.kCFStringEncodingUTF8.value);
        if (ok == 0) {
            throw new RococoaException("Could not convert string");
        }
        return Native.toString((byte[])buffer);
    }

    public static ID getClass(String className) {
        if (logging.isLoggable(Level.FINEST)) {
            logging.finest(String.format("calling objc_getClass(%s)", className));
        }
        return foundationLibrary.objc_getClass(className);
    }

    public static Selector selector(String selectorName) {
        Selector cached = selectorCache.get(selectorName);
        if (cached != null) {
            return cached;
        }
        Selector result = foundationLibrary.sel_registerName(selectorName).initName(selectorName);
        selectorCache.put(selectorName, result);
        return result;
    }

    public static <T> T send(ID receiver, String selectorName, Class<T> returnType, Object ... args) {
        return Foundation.send(receiver, selectorName, returnType, null, args);
    }

    public static <T> T send(ID receiver, String selectorName, Class<T> returnType, Method method, Object ... args) {
        return Foundation.send(receiver, Foundation.selector(selectorName), returnType, method, args);
    }

    public static <T> T send(ID receiver, Selector selector, Class<T> returnType, Object ... args) {
        return Foundation.send(receiver, selector, returnType, null, args);
    }

    public static <T> T send(ID receiver, Selector selector, Class<T> returnType, Method method, Object ... args) {
        if (logging.isLoggable(Level.FINEST)) {
            logging.finest(String.format("sending (%s) %s.%s(%s)", new Object[]{returnType.getSimpleName(), receiver, selector.getName(), new VarArgsUnpacker(args)}));
        }
        if (method != null && method.isVarArgs()) {
            return (T)messageSendLibrary.syntheticSendVarArgsMessage(returnType, receiver, selector, args);
        }
        return (T)messageSendLibrary.syntheticSendMessage(returnType, receiver, selector, args);
    }

    public static ID sendReturnsID(ID receiver, String selectorName, Object ... args) {
        return Foundation.send(receiver, Foundation.selector(selectorName), ID.class, args);
    }

    public static void sendReturnsVoid(ID receiver, String selectorName, Object ... args) {
        Foundation.send(receiver, Foundation.selector(selectorName), Void.TYPE, args);
    }

    public static boolean isMainThread() {
        return MainThreadUtils.isMainThread();
    }

    public static <T> T callOnMainThread(Callable<T> callable) {
        return MainThreadUtils.callOnMainThread(rococoaLibrary, callable);
    }

    public static void runOnMainThread(Runnable runnable) {
        MainThreadUtils.runOnMainThread(rococoaLibrary, runnable, true);
    }

    public static void runOnMainThread(Runnable runnable, boolean waitUntilDone) {
        MainThreadUtils.runOnMainThread(rococoaLibrary, runnable, waitUntilDone);
    }

    public static ID newOCProxy(OCInvocationCallbacks callbacks) {
        return rococoaLibrary.proxyForJavaObject(callbacks.selectorInvokedCallback, callbacks.methodSignatureCallback);
    }

    public static boolean selectorNameMeansWeOwnReturnedObject(String selectorName) {
        return selectorName.startsWith("alloc") || selectorName.startsWith("new") || selectorName.toLowerCase().contains("copy");
    }

    static {
        selectorCache = new HashMap<String, Selector>();
        logging.finest("Initializing Foundation");
        System.setProperty("jna.encoding", "UTF8");
        HashMap<String, MsgSendInvocationMapper> messageSendLibraryOptions = new HashMap<String, MsgSendInvocationMapper>(1);
        messageSendLibraryOptions.put("invocation-mapper", new MsgSendInvocationMapper());
        messageSendLibrary = (MsgSendLibrary)Native.load((String)"Foundation", MsgSendLibrary.class, messageSendLibraryOptions);
        foundationLibrary = (FoundationLibrary)Native.load((String)"Foundation", FoundationLibrary.class);
        rococoaLibrary = (RococoaLibrary)Native.load((String)"rococoa", RococoaLibrary.class);
        logging.finest("exit initializing Foundation");
    }
}

