/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.util.win;

import java.lang.reflect.Method;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtil {
    private static final int HKEY_CURRENT_USER = -2147483647;
    private static final int KEY_WRITE = 131078;
    private static final String WINDOWS_REG_CLOSE_KEY = "WindowsRegCloseKey";
    private static final String WINDOWS_REG_CREATE_KEY_EX = "WindowsRegCreateKeyEx";
    private static final String WINDOWS_REG_OPEN_KEY = "WindowsRegOpenKey";
    private static final String WINDOWS_REG_SET_VALUE_EX = "WindowsRegSetValueEx";
    private static Logger _logger = LoggerFactory.getLogger((String)RegistryUtil.class.getName());
    private static Class<? extends Preferences> _clazz = null;
    private static Preferences _userRoot = null;

    public static boolean writeRegistry(String key, String name, int value) {
        return RegistryUtil.writeRegistry(key, name, String.valueOf(value));
    }

    public static boolean writeRegistry(String key, String name, String value) {
        try {
            RegistryUtil._init();
            boolean result = RegistryUtil._regCreateKeyEx(key);
            if (!result) {
                return false;
            }
            int handle = RegistryUtil._regOpenKeyToWrite(key);
            if (handle == 0) {
                return false;
            }
            boolean success = RegistryUtil._regSetStringValueEx(handle, name, value);
            if (!RegistryUtil._regCloseKey(handle)) {
                return false;
            }
            return success;
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void _init() {
        if (_userRoot == null) {
            _userRoot = Preferences.userRoot();
        }
        if (_clazz == null) {
            _clazz = _userRoot.getClass();
        }
    }

    private static boolean _regCloseKey(int handle) throws Exception {
        Method regCloseKey = _clazz.getDeclaredMethod(WINDOWS_REG_CLOSE_KEY, Integer.TYPE);
        regCloseKey.setAccessible(true);
        regCloseKey.invoke((Object)_userRoot, handle);
        return true;
    }

    private static boolean _regCreateKeyEx(String key) throws Exception {
        Method regCreateKeyEx = _clazz.getDeclaredMethod(WINDOWS_REG_CREATE_KEY_EX, Integer.TYPE, byte[].class);
        regCreateKeyEx.setAccessible(true);
        Object result = regCreateKeyEx.invoke((Object)_userRoot, -2147483647, RegistryUtil._stringToByteArray(key));
        if (result == null) {
            return false;
        }
        if (result instanceof int[]) {
            int[] handle = (int[])result;
            if (handle.length == 0) {
                return false;
            }
            return RegistryUtil._regCloseKey(handle[0]);
        }
        return false;
    }

    private static int _regOpenKeyToWrite(String key) throws Exception {
        Method regOpenKey = _clazz.getDeclaredMethod(WINDOWS_REG_OPEN_KEY, Integer.TYPE, byte[].class, Integer.TYPE);
        regOpenKey.setAccessible(true);
        Object object = regOpenKey.invoke((Object)_userRoot, -2147483647, RegistryUtil._stringToByteArray(key), 131078);
        if (object == null) {
            return 0;
        }
        if (object instanceof int[]) {
            int[] results = (int[])object;
            if (results.length == 0) {
                return 0;
            }
            return results[0];
        }
        return 0;
    }

    private static boolean _regSetStringValueEx(int handle, String name, String value) throws Exception {
        Method regSetValueEx = _clazz.getDeclaredMethod(WINDOWS_REG_SET_VALUE_EX, Integer.TYPE, byte[].class, byte[].class);
        regSetValueEx.setAccessible(true);
        Object object = regSetValueEx.invoke((Object)_userRoot, handle, RegistryUtil._stringToByteArray(name), RegistryUtil._stringToByteArray(value));
        if (object instanceof Integer) {
            int result = (Integer)object;
            if (result == 0) {
                return true;
            }
            _logger.error("Unable to set registry value {} {}", (Object)name, (Object)result);
        }
        return false;
    }

    private static byte[] _stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }
}

