/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.util.mac;

import com.liferay.nativity.util.mac.AppleScriptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleUtil {
    private static Logger _logger = LoggerFactory.getLogger((String)AppleUtil.class.getName());

    public static String getBundleVersion(String bundlePath) {
        try {
            String script = AppleScriptUtil.getScript("getbundleversion.applescript", bundlePath);
            return (String)AppleScriptUtil.executeScript(script);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String getInstalledBundleVersion() {
        try {
            String script = AppleScriptUtil.getScript("getbundleversion.applescript", "/Library/ScriptingAdditions/LiferayNativity.osax");
            return (String)AppleScriptUtil.executeScript(script);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static void installScripts(String sourcePath) {
        try {
            String script = AppleScriptUtil.getScript("installscripts.applescript", sourcePath);
            AppleScriptUtil.executeScript(script);
            Thread.sleep(1000L);
            AppleUtil.reloadScripts();
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean load() {
        try {
            String script = AppleScriptUtil.getScript("load.applescript");
            AppleScriptUtil.executeScript(script);
            return true;
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean loaded() {
        try {
            String script = AppleScriptUtil.getScript("loaded.applescript");
            Long result = (Long)AppleScriptUtil.executeScript(script);
            return result != null && result == 0L;
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void reloadScripts() {
        try {
            String script = AppleScriptUtil.getScript("reloadscripts.applescript");
            AppleScriptUtil.executeScript(script);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void uninstallScripts() {
        try {
            String script = AppleScriptUtil.getScript("uninstallscripts.applescript");
            AppleScriptUtil.executeScript(script);
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean unload() {
        try {
            String script = AppleScriptUtil.getScript("unload.applescript");
            AppleScriptUtil.executeScript(script);
            return true;
        }
        catch (Exception e) {
            _logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

