/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.util.mac;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class AppleScriptUtil {
    private static ScriptEngine _appleScriptEngine;
    private static Map<String, String> _loadedScripts;
    private static ScriptEngineManager _scriptEngineManager;

    public static Object executeScript(String script) throws ScriptException {
        if (_appleScriptEngine == null && (_appleScriptEngine = (_scriptEngineManager = new ScriptEngineManager()).getEngineByName("AppleScriptEngine")) == null && (_appleScriptEngine = _scriptEngineManager.getEngineByName("AppleScript")) == null) {
            throw new ScriptException("AppleScriptEngine not available");
        }
        return _appleScriptEngine.eval(script, _appleScriptEngine.getContext());
    }

    public static String getScript(String scriptName) throws IOException {
        if (_loadedScripts.containsKey(scriptName)) {
            return _loadedScripts.get(scriptName);
        }
        InputStream is = AppleScriptUtil.class.getResourceAsStream("/resources/osax/" + scriptName);
        if (is == null) {
            return null;
        }
        String script = AppleScriptUtil.getString(is);
        _loadedScripts.put(scriptName, script);
        return script;
    }

    public static String getScript(String scriptName, Object ... arguments) throws IOException {
        String script = AppleScriptUtil.getScript(scriptName);
        return MessageFormat.format(script, arguments);
    }

    private static String getString(InputStream is) {
        Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");
        if (scanner.hasNext()) {
            return scanner.next();
        }
        return "";
    }

    static {
        _loadedScripts = new HashMap<String, String>();
    }
}

